package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.PSObject;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of AddCollectionRequest element --&gt;
 *     &lt;xs:element name="AddCollectionRequest" type="AddCollectionRequestType"/&gt;
 *     &lt;!-- Definition of AddCollectionRequestType --&gt;
 *     &lt;xs:complexType name="AddCollectionRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * 
 * </pre>
 * @author asa
 *
 */
public class AddCollectionRequest extends RequestAbstractType
{
    public static final String LOCAL_NAME = AddCollectionRequest.class.getSimpleName();
    
    // Elements
    private PSObject object;
    private Subscription subscription;
    
    public AddCollectionRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected AddCollectionRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public PSObject getObject()
    {
        return object;
    }

    public void setObject(PSObject object)
    {
        this.object = prepareForAssignment(this.object, object);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(object);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<AddCollectionRequest>
    {
        @Override
        public AddCollectionRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new AddCollectionRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            AddCollectionRequest object = (AddCollectionRequest) parentXMLObject;     
            
            if(childXMLObject instanceof PSObject) 
            {
                object.setObject((PSObject) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }
        
    }
    
}