package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.PSObject;
import org.openliberty.xmltooling.security.TokenPolicy;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * 
 * <pre>
 *     &lt;!-- Declaration of AddEntityRequest element --&gt;
 *     &lt;xs:element name="AddEntityRequest" type="AddEntityRequestType"/&gt;
 *     &lt;!-- Definition of AddEntityRequestType --&gt;
 *     &lt;xs:complexType name="AddEntityRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object"/&gt;
 *                     &lt;xs:element ref="PStoSPRedirectURL" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="CreatePSObject" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="sec:TokenPolicy" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class AddEntityRequest extends RequestAbstractType
{	
    public static final String LOCAL_NAME = AddEntityRequest.class.getSimpleName();
    
    // Elements
    private PSObject object;
    private PStoSPRedirectURL pStoSPRedirectURL;
    private CreatePSObject createPSObject;
    private Subscription subscription;
    private TokenPolicy tokenPolicy;
    
    public AddEntityRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected AddEntityRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public CreatePSObject getCreatePSObject()
    {
        return createPSObject;
    }

    public void setCreatePSObject(CreatePSObject createPSObject)
    {
        this.createPSObject = prepareForAssignment(this.createPSObject, createPSObject);
    }

    public PSObject getObject()
    {
        return object;
    }

    public void setObject(PSObject object)
    {
        this.object = prepareForAssignment(this.object, object);
    }

    public PStoSPRedirectURL getPStoSPRedirectURL()
    {
        return pStoSPRedirectURL;
    }

    public void setPStoSPRedirectURL(PStoSPRedirectURL pStoSPRedirectURL)
    {
        pStoSPRedirectURL = prepareForAssignment(this.pStoSPRedirectURL, pStoSPRedirectURL);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public TokenPolicy getTokenPolicy()
    {
        return tokenPolicy;
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy)
    {
        this.tokenPolicy = prepareForAssignment(this.tokenPolicy, tokenPolicy);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(object);
        children.add(pStoSPRedirectURL);
        children.add(createPSObject);
        children.add(subscription);
        children.add(tokenPolicy);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<AddEntityRequest>
    {
        @Override
        public AddEntityRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new AddEntityRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            AddEntityRequest object = (AddEntityRequest) parentXMLObject;     
            
            if(childXMLObject instanceof PSObject) 
            {
                object.setObject((PSObject) childXMLObject);
            }
            else if(childXMLObject instanceof PStoSPRedirectURL)
            {
                object.setPStoSPRedirectURL((PStoSPRedirectURL) childXMLObject);
            }
            else if(childXMLObject instanceof CreatePSObject)
            {
                object.setCreatePSObject((CreatePSObject) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }
            else if(childXMLObject instanceof TokenPolicy)
            {
                object.setTokenPolicy((TokenPolicy) childXMLObject);
            }
            
        }
        
    }
    
}
