package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.PSObject;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.security.TokenPolicy;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * If a WSC knows an identifier for a user at some identity provider, it can provide this to the PS provider in an
 * &lt;AddKnownEntityRequest&gt; message. This known identifier can act as a bootstrap for the establishment of the
 * necessary federations. For instance, if the inviting user provides an email address for the invited user, this address
 * may allow the identity provider for that user to be ascertained, thereby obviating the need to ask the user for this
 * information.
 * <p>
 * A WSC indicates to the PS provider that it wishes a known user Object to be created by sending an
 * &lt;AddKnownEntityRequest&gt; message. The Object being created MUST be a urn:liberty:ps:entity Object.
 * The &lt;AddKnownEntityRequest&gt; message carries the known identifier for the relevant user within.
 * </p>
 * <p>
 * As for the &lt;AddKnownEntity&gt; message, the presence of a &lt;Subscription&gt; element indicates to the PS provider
 * that the WSC desires that the PS provider return to it (when later possible) an identity token for the invited user within
 * a &lt;Notification&gt; element in a &lt;Notify&gt; message - this possible after a federation has been established between
 * the PS provider and the appropriate IDP. If no &lt;Subscription&gt; element is present, the WSC is indicating that the
 * PS provider need not return an identity token through this mechanism.
 * </p>
 * <p>
 * <pre>
 *     &lt;!-- Declaration of AddKnownEntityRequest element --&gt;
 *     &lt;xs:element name="AddKnownEntityRequest" type="AddKnownEntityRequestType"/&gt;
 *     &lt;!-- Definition of AddKnownEntityRequestType --&gt;
 *     &lt;xs:complexType name="AddKnownEntityRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object"/&gt;
 *                     &lt;xs:element ref="sec:Token"/&gt;
 *                     &lt;xs:element ref="CreatePSObject" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="sec:TokenPolicy" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * </p>
 * 
 * @author asa
 *
 */
public class AddKnownEntityRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = AddKnownEntityRequest.class.getSimpleName();
    
    // Elements
    private PSObject object;
    private Token token;
    private CreatePSObject createPSObject;
    private Subscription subscription;
    private TokenPolicy tokenPolicy;
        
    public AddKnownEntityRequest(PSObject entity, Token token)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.object = entity;
        this.token = token;
    }
    
    protected AddKnownEntityRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public CreatePSObject getCreatePSObject()
    {
        return createPSObject;
    }

    public void setCreatePSObject(CreatePSObject createPSObject)
    {
        this.createPSObject = prepareForAssignment(this.createPSObject, createPSObject);
    }

    public PSObject getObject()
    {
        return object;
    }

    public void setObject(PSObject object)
    {
        this.object = prepareForAssignment(this.object, object);
    }

    public Token getToken()
    {
        return token;
    }

    public void setToken(Token token)
    {
        token = prepareForAssignment(this.token, token);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public TokenPolicy getTokenPolicy()
    {
        return tokenPolicy;
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy)
    {
        this.tokenPolicy = prepareForAssignment(this.tokenPolicy, tokenPolicy);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(object);
        children.add(token);
        children.add(createPSObject);
        children.add(subscription);
        children.add(tokenPolicy);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<AddKnownEntityRequest>
    {
        @Override
        public AddKnownEntityRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new AddKnownEntityRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            AddKnownEntityRequest object = (AddKnownEntityRequest) parentXMLObject;     
            
            if(childXMLObject instanceof PSObject) 
            {
                object.setObject((PSObject) childXMLObject);
            }
            else if(childXMLObject instanceof PStoSPRedirectURL)
            {
                object.setToken((Token) childXMLObject);
            }
            else if(childXMLObject instanceof CreatePSObject)
            {
                object.setCreatePSObject((CreatePSObject) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }
            else if(childXMLObject instanceof TokenPolicy)
            {
                object.setTokenPolicy((TokenPolicy) childXMLObject);
            }
            
        }
        
    }
    
}
