package org.openliberty.xmltooling.ps.request;


import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;

/**
 * The &lt;CreatePSObject&gt; element allows a WSC to indicate that it desires the PS
 * provider create (or verify the existence of) an Object for the inviting user at the PS provider
 * of the invited user (i.e. create or verify the reciprocal relationship).
 * 
 * <pre>
 *     &lt;!-- Declaration of CreatePSObject element --&gt;
 *     &lt;xs:element name="CreatePSObject"/&gt;
 *     </pre>
 * @author asa
 *
 *
 *
 */
public class CreatePSObject extends XSStringImpl
{
    // TODO: figure out the syntax used for this element
    
    public static final String LOCAL_NAME = "CreatePSObject";

    public CreatePSObject()
    {
    	super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected CreatePSObject(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<CreatePSObject>
    {
        @Override
        public CreatePSObject buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new CreatePSObject(namespaceURI, localName, namespacePrefix);
        }        
    }

    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSStringMarshaller
    {
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSStringUnmarshaller
    {        
    }



}