package org.openliberty.xmltooling.ps.request;

import java.util.List;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class Filter extends AbstractXMLObject
{
    public static final String LOCAL_NAME = "Filter";

    //  <Filter>//Object[@NodeType=�urn: liberty:ps:entity�]</Filter>
    private String pathExpression;
    

    public Filter(String pathExpression)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.setPathExpression(pathExpression);
    }

    protected Filter(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getPathExpression()
    {
        return pathExpression;
    }

    public void setPathExpression(String pathExpression)
    {
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        try
        {
            path.compile(pathExpression);
            this.pathExpression = prepareForAssignment(this.pathExpression, pathExpression);;
        }
        catch (XPathExpressionException e)
        {
            e.printStackTrace();
            this.pathExpression = prepareForAssignment(this.pathExpression, "");
        }
    	
        
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Filter>
    {
        @Override
        public Filter buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Filter(namespaceURI, localName, namespacePrefix);
        }        
    }

    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no attributes
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Filter filter = (Filter) xmlObject;
            if(null!=filter.getPathExpression())
            {
                ElementSupport.appendTextContent(domElement, filter.getPathExpression());       
            }
            else
            {
                ElementSupport.appendTextContent(domElement, "");
            }
        }

    }

    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            // no atts
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            // no children            
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            Filter filter = (Filter)xmlObject;
            filter.setPathExpression(elementContent);            
        }
        
    }



}
