package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of GetObjectInfoRequest element --&gt;
 *     &lt;xs:element name="GetObjectInfoRequest" type="GetObjectInfoRequestType"/&gt;
 *     &lt;!-- Definition of GetObjectInfoRequestType --&gt;
 *     &lt;xs:complexType name="GetObjectInfoRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class GetObjectInfoRequest extends RequestAbstractType
{

    public static String LOCAL_NAME = GetObjectInfoRequest.class.getSimpleName();
    
    // Elements
    private TargetObjectID targetObjectID;
    private Subscription subscription;

    public GetObjectInfoRequest(TargetObjectID targetObjectID)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.targetObjectID = targetObjectID;
    }

    protected GetObjectInfoRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public TargetObjectID getTargetObjectID()
    {
        return targetObjectID;
    }    

    public void setTargetObjectID(TargetObjectID targetObjectID)
    {
        this.targetObjectID = prepareForAssignment(this.targetObjectID, targetObjectID);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(targetObjectID);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }


    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<GetObjectInfoRequest>
    {
        @Override
        public GetObjectInfoRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new GetObjectInfoRequest(namespaceURI, localName, namespacePrefix);
        }
    }

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            GetObjectInfoRequest object = (GetObjectInfoRequest) parentXMLObject;     

            if(childXMLObject instanceof TargetObjectID) 
            {
                object.setTargetObjectID((TargetObjectID) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }

    }

}