package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *     &lt;!-- Declaration of ListMembersRequest element --&gt;
 *     &lt;xs:element name="ListMembersRequest" type="ListMembersRequestType"/&gt;
 *     &lt;!-- Definition of ListMembersRequestType --&gt;
 *     &lt;xs:complexType name="ListMembersRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *                 &lt;xs:attribute name="Structured" type="xs:anyURI" use="optional"/&gt;
 *                 &lt;xs:attribute name="Count" type="xs:nonNegativeInteger" use="optional"/&gt;
 *                 &lt;xs:attribute name="Offset" type="xs:nonNegativeInteger" default="0" use="optional"/&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class ListMembersRequest extends RequestAbstractType
{

	public static String LOCAL_NAME = ListMembersRequest.class.getSimpleName();

	public static int NO_COUNT = 0;
	public static int NO_OFFSET = 0;
	
    // Attributes
    private String structured;
    private Integer count;      
    private Integer offset;     // default 0  

    // Attribute Names
    public static final String ATT_STRUCTURED = "Structured";
    public static final String ATT_COUNT = "Count";
    public static final String ATT_OFFSET = "Offset";

    // Elements
    private TargetObjectID targetObjectID;
    private Subscription subscription;

    public ListMembersRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }

    public ListMembersRequest(TargetObjectID targetObjectID)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.targetObjectID = targetObjectID;
    }

    protected ListMembersRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public TargetObjectID getTargetObjectID()
    {
        return targetObjectID;
    }    

    public void setTargetObjectID(TargetObjectID targetObjectID)
    {
        this.targetObjectID = prepareForAssignment(this.targetObjectID, targetObjectID);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public Integer getCount()
    {
        return count;
    }

    public void setCount(Integer count)
    {
        this.count = prepareForAssignment(this.count, count);
    }

    public Integer getOffset()
    {
        return offset;
    }

    public void setOffset(Integer offset)
    {
        this.offset = prepareForAssignment(this.offset, offset);
    }

    public String getStructured()
    {
        return structured;
    }

    public void setStructured(String structured)
    {
        this.structured = prepareForAssignment(this.structured, structured);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(targetObjectID);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }


    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ListMembersRequest>
    {
        @Override
        public ListMembersRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ListMembersRequest(namespaceURI, localName, namespacePrefix);
        }
    }

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            ListMembersRequest obj = (ListMembersRequest)xmlObject;            
            
            if(obj.getCount()!=null)
            {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_COUNT, obj.getCount().toString());
            }

            if(obj.getOffset()!=null)
            {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_OFFSET, obj.getOffset().toString());
            }

            if(obj.getStructured()!=null)
            {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_STRUCTURED, obj.getStructured());
            }
            
            //obj.getNotifyAttributeGroup().marshallAttributes(domElement);            
            super.marshallAttributes(xmlObject, domElement);
        }
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            ListMembersRequest obj = (ListMembersRequest) xmlObject;
            
            String attLocalName = attribute.getLocalName();
            
            if(attLocalName.equals(ListMembersRequest.ATT_STRUCTURED)) 
            {
                obj.setStructured(attribute.getValue());
            }
            else if(attLocalName.equals(ListMembersRequest.ATT_COUNT)) 
            {
                obj.setCount(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), null));
            }
            else if(attLocalName.equals(ListMembersRequest.ATT_OFFSET)) 
            {
                obj.setOffset(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), 0));
            }
            else
            {
                super.processAttribute(xmlObject, attribute);
            }
        }


        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            ListMembersRequest object = (ListMembersRequest) parentXMLObject;     

            if(childXMLObject instanceof TargetObjectID) 
            {
                object.setTargetObjectID((TargetObjectID) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }

    }

}