package org.openliberty.xmltooling.ps.request;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.NotificationType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of Notification element --&gt;
 *     &lt;xs:element name="Notification" type="NotificationType"/&gt;
 *     &lt;!-- Definition of NotificationType --&gt;
 *     &lt;xs:complexType name="NotificationType"&gt;
 *        &lt;xs:complexContent&gt;
 *           &lt;xs:extension base="subs:NotificationType"&gt;
 *              &lt;xs:sequence&gt;
 *                 &lt;xs:element ref="ItemData" minOccurs="0" maxOccurs="unbounded"/&gt;
 *              &lt;/xs:sequence&gt;
 *           &lt;/xs:extension&gt;
 *        &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class Notification extends NotificationType
{
        
    public static final String LOCAL_NAME = "Notification";
    
    // Elements
    private XMLObjectChildrenList<ItemData> itemDatas;
    
    public Notification()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected Notification(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }    
    
    public XMLObjectChildrenList<ItemData> getItemDatas()
    {
        if(null==itemDatas) itemDatas = new XMLObjectChildrenList<ItemData>(this);
        return itemDatas;
    }
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Notification>
    {
        @Override
        public Notification buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Notification(namespaceURI, localName, namespacePrefix);
        }        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends NotificationType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            Notification obj = (Notification)parentXMLObject;

            if(childXMLObject instanceof ItemData)
            {
                obj.getItemDatas().add((ItemData)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends NotificationType.Marshaller
    {        
    }
    
    
    
    

}
