package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.NotifyAttributeGroup;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *     &lt;!-- Declaration of Notify element --&gt;
 *     &lt;xs:element name="Notify" type="NotifyType"/&gt;
 *     &lt;!-- Definition of NotifyType --&gt;
 *     &lt;xs:complexType name="NotifyType"&gt;
 *        &lt;xs:complexContent&gt;
 *           &lt;xs:extension base="RequestAbstractType"&gt;
 *              &lt;xs:sequence&gt;
 *                 &lt;xs:element ref="Notification" minOccurs="0" maxOccurs="unbounded"/&gt;
 *              &lt;/xs:sequence&gt;
 *              &lt;xs:attributeGroup ref="subs:NotifyAttributeGroup"/&gt;
 *           &lt;/xs:extension&gt;
 *        &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class Notify extends RequestAbstractType
{

    public static String LOCAL_NAME = "Notify";

    // Attributes
    private NotifyAttributeGroup notifyAttributeGroup = new NotifyAttributeGroup();

    // Elements
    private XMLObjectChildrenList<Notification> notifications;

    public Notify()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }

    protected Notify(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public NotifyAttributeGroup getNotifyAttributeGroup()
    {
        return notifyAttributeGroup;   
    }

    public XMLObjectChildrenList<Notification> getNotifications()
    {
        if(null==notifications) notifications = new XMLObjectChildrenList<Notification>(this);
        return notifications;
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        if(null!=notifications) children.addAll(notifications);

        return Collections.unmodifiableList(children);
    }


    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Notify>
    {
        @Override
        public Notify buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Notify(namespaceURI, localName, namespacePrefix);
        }
    }

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Notify obj = (Notify)xmlObject;            
            obj.getNotifyAttributeGroup().marshallAttributes(domElement);            
            super.marshallAttributes(xmlObject, domElement);
        }
        
    }


    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            Notify obj = (Notify) xmlObject;
            if(!obj.getNotifyAttributeGroup().processAttribute(attribute, (AbstractXMLObject)xmlObject)) 
            {
                super.processAttribute(xmlObject, attribute);
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            Notify object = (Notify) parentXMLObject;     
            if(childXMLObject instanceof Notification) 
            {
                object.getNotifications().add((Notification) childXMLObject);
            }

        }

    }

}