package org.openliberty.xmltooling.ps.request;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSURIImpl;
import org.opensaml.core.xml.schema.impl.XSURIMarshaller;
import org.opensaml.core.xml.schema.impl.XSURIUnmarshaller;

/**
 * This is part of the invitation model
 * <p>
 * The SP MAY use the &lt;PStoSPRedirectURL&gt; element on &lt;AddEntityRequest&gt; and &lt;AddKnownEntityRequest&gt;
 * messages to specify to the PS provider the URL (at the SP) to which that SP desires the invited user�s user agent be
 * directed after successful interaction and IDP federation has occurred. If and when the invited user�s user agent has
 * been sent to this URL, the SP MAY provide the invited user the designated access to the resource in question.
 * </p>
 * <p>
 * The value of the &lt;PStoSPRedirectURL&gt; element MUST be such that, if and when a user agent is sent to this address
 * from the PS provider, the SP can unambiguously determine the invitation to which the URL
 * </p>
 * <p>
 *  <pre>
 *     &lt;!-- Declaration of PStoSPRedirectURL--&gt;
 * 
 *     &lt;xs:element name="PStoSPRedirectURL" type="PStoSPRedirectURLType"/&gt;
 * 
 *     &lt;!-- Definition of PStoSPRedirectURLType--&gt;
 * 
 *     &lt;xs:complexType name="PStoSPRedirectURLType"&gt;
 *         &lt;xs:annotation&gt;
 *             &lt;xs:documentation&gt;When sending a AddEntityRequest to a PS provider, the SP may insert a PStoSPRedirectURL. It will be to this URL that the invited principals will be sent after federating their IDP account to the PS provider.&lt;/xs:documentation&gt;
 *         &lt;/xs:annotation&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:anyURI"/&gt;
 *         &lt;/xs:simpleContent&gt;
 *     &lt;/xs:complexType&gt;
 *     </pre>
 * </p>
 * @author asa
 *
 */
public class PStoSPRedirectURL extends XSURIImpl
{

    public static String LOCAL_NAME = "PStoSPRedirectURL";

    public PStoSPRedirectURL()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected PStoSPRedirectURL(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<PStoSPRedirectURL>
    {
        @Override
        public PStoSPRedirectURL buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new PStoSPRedirectURL(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSURIMarshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSURIUnmarshaller
    {        
    }
    
}
