package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * <pre>
 *     &lt;!-- Declaration of QueryObjectsRequest element --&gt;
 *     &lt;xs:element name="QueryObjectsRequest" type="QueryObjectsRequestType"/&gt;
 *     &lt;!-- Definition of QueryObjectsRequestType --&gt;
 *     &lt;xs:complexType name="QueryObjectsRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element name="Filter" type="xs:string"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *                 &lt;xs:attribute name="Count" type="xs:nonNegativeInteger" use="optional"/&gt;
 *                 &lt;xs:attribute name="Offset" type="xs:nonNegativeInteger" default="0" use="optional"/&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class QueryObjectsRequest extends RequestAbstractType
{

    public static String LOCAL_NAME = QueryObjectsRequest.class.getSimpleName();

    // Attributes
    private Integer count;      
    private Integer offset;     // default 0

    // Attribute Names
    public static final String ATT_COUNT = "Count";
    public static final String ATT_OFFSET = "Offset";

    // Elements
    private Filter filter;
    private Subscription subscription;

    public QueryObjectsRequest(Filter filter)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.filter = filter;
    }

    protected QueryObjectsRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Filter getFilter()
    {
        return filter;
    }

    public void setFilter(Filter filter)
    {
        this.filter = prepareForAssignment(this.filter, filter);
    }
    
    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public Integer getCount()
    {
        return count;
    }

    public void setCount(Integer count)
    {
        this.count = prepareForAssignment(this.count, count);
    }

    public Integer getOffset()
    {
        return offset;
    }

    public void setOffset(Integer offset)
    {
        this.offset = prepareForAssignment(this.offset, offset);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(filter);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }


    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<QueryObjectsRequest>
    {
        @Override
        public QueryObjectsRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new QueryObjectsRequest(namespaceURI, localName, namespacePrefix);
        }
    }

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            QueryObjectsRequest obj = (QueryObjectsRequest) xmlObject;
            
            String attLocalName = attribute.getLocalName();
            
            if(attLocalName.equals(ListMembersRequest.ATT_COUNT)) 
            {
                obj.setCount(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), null));
            }
            else if(attLocalName.equals(ListMembersRequest.ATT_OFFSET)) 
            {
                obj.setOffset(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), 0));
            }
            else
            {
                super.processAttribute(xmlObject, attribute);
            }
        }


        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            QueryObjectsRequest object = (QueryObjectsRequest) parentXMLObject;     

            if(childXMLObject instanceof Filter) 
            {
                object.setFilter((Filter) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }

    }


}