package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of RemoveCollectionRequest element --&gt;
 *     &lt;xs:element name="RemoveCollectionRequest" type="RemoveCollectionRequestType"/&gt;
 *     &lt;!-- Definition of RemoveCollectionRequestType --&gt;
 *     &lt;xs:complexType name="RemoveCollectionRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID" maxOccurs="unbounded"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class RemoveCollectionRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = RemoveCollectionRequest.class.getSimpleName();
    
    // Elements
    private XMLObjectChildrenList<TargetObjectID> targetObjectIDs;

    public RemoveCollectionRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        targetObjectIDs = new XMLObjectChildrenList<TargetObjectID>(this);
    }
    
    public RemoveCollectionRequest(TargetObjectID targetObjectID)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        targetObjectIDs = new XMLObjectChildrenList<TargetObjectID>(this);
        targetObjectIDs.add(targetObjectID);
    }
    
    protected RemoveCollectionRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        targetObjectIDs = new XMLObjectChildrenList<TargetObjectID>(this);
    }

    public XMLObjectChildrenList<TargetObjectID> getTargetObjectIDs()
    {
        return targetObjectIDs;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.addAll(targetObjectIDs);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<RemoveCollectionRequest>
    {
        @Override
        public RemoveCollectionRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new RemoveCollectionRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            RemoveCollectionRequest object = (RemoveCollectionRequest) parentXMLObject;     
            
            if(childXMLObject instanceof TargetObjectID)
            {
                object.getTargetObjectIDs().add((TargetObjectID) childXMLObject);
            }            

        }
        
    }
    
}