package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.ObjectID;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of RemoveFromCollectionRequest element --&gt;
 *     &lt;xs:element name="RemoveFromCollectionRequest" type="RemoveFromCollectionRequestType"/&gt;
 *     &lt;!-- Definition of RemoveFromCollectionRequestType --&gt;
 *     &lt;xs:complexType name="RemoveFromCollectionRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID"/&gt;
 *                     &lt;xs:element ref="ObjectID" maxOccurs="unbounded"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class RemoveFromCollectionRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = RemoveFromCollectionRequest.class.getSimpleName();
    
    // Elements
    private TargetObjectID targetObjectID;
    private XMLObjectChildrenList<ObjectID> objectIDs;
    private Subscription subscription;
    
    public RemoveFromCollectionRequest(TargetObjectID targetObjectID, ObjectID objectID)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        objectIDs = new XMLObjectChildrenList<ObjectID>(this);
        objectIDs.add(objectID);
        this.targetObjectID = targetObjectID;
    }
    
    public RemoveFromCollectionRequest(TargetObjectID targetObjectID, List<ObjectID> objectIDs)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.objectIDs = new XMLObjectChildrenList<ObjectID>(this);
        this.objectIDs.addAll(objectIDs);
        this.targetObjectID = targetObjectID;
    }

    
    protected RemoveFromCollectionRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        objectIDs = new XMLObjectChildrenList<ObjectID>(this);
    }

    public TargetObjectID getTargetObjectID()
    {
        return targetObjectID;
    }    
    
    public void setTargetObjectID(TargetObjectID targetObjectID)
    {
        this.targetObjectID = prepareForAssignment(this.targetObjectID, targetObjectID);
    }

    public XMLObjectChildrenList<ObjectID> getObjectIDs()
    {
        return objectIDs;
    }
    
    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(targetObjectID);
        children.addAll(objectIDs);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<RemoveFromCollectionRequest>
    {
        @Override
        public RemoveFromCollectionRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new RemoveFromCollectionRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            RemoveFromCollectionRequest object = (RemoveFromCollectionRequest) parentXMLObject;     
            
            if(childXMLObject instanceof TargetObjectID) 
            {
                object.setTargetObjectID((TargetObjectID) childXMLObject);
            }
            else if(childXMLObject instanceof ObjectID)
            {
                object.getObjectIDs().add((ObjectID) childXMLObject);
            }            
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }
        
    }
    
}
