package org.openliberty.xmltooling.ps.request;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.ps.Konstantz.PeopleServiceRequestType;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * All PS requests extend this Base implementation which provides a mechanism for determining
 * an expected response type to the request type through the type() method.
 *
 * <pre>
 *     &lt;!-- Definition of RequestAbstractType --&gt;
 *     &lt;xs:complexType name="RequestAbstractType" abstract="true"&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public abstract class RequestAbstractType extends AbstractXMLObject implements AttributeExtensibleXMLObject, BasePeopleServiceRequest
{

    // Attributes
    private AttributeMap otherAttributes;

    protected RequestAbstractType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public AttributeMap getUnknownAttributes()
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }

	public PeopleServiceRequestType type() 
	{
		return PeopleServiceRequestType.typeForClass(this.getClass());
	}

    public String actionURI()
    {
    	PeopleServiceRequestType type = type();
    	if(null!=type) return type.actionURI();
    	else return "";   
    }

    public Class<?> responseClass()
    {
    	PeopleServiceRequestType type = type();
    	if(null!=type) return type.responseClass();
    	else return null;   
    }    
	
    /**
     * Internal marshaller, placing attribute values into the DOM
     * @author asa
     *
     */
    public abstract static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            RequestAbstractType obj = (RequestAbstractType)xmlObject;

            // marshall the unknown attributes (supported by RequestType)
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }

    /**
     * Internal unmarshaller, placing DOM atts into the XMLObject
     * and connecting child elements
     * 
     * @author asa
     *
     */
    public abstract static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            RequestAbstractType obj = (RequestAbstractType) xmlObject;

            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

      @Override
      protected void processElementContent(XMLObject xmlObject, String elementContent)
      {
          // no element content
      }


    }




}
