package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.Konstantz.PeopleServiceRequestType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 * 
 *     &lt;!-- Declaration of ResolveIdentifierRequest element --&gt;
 *     &lt;xs:element name="ResolveIdentifierRequest" type="ResolveIdentifierRequestType"/&gt;
 *     &lt;!-- Definition of ResolveIdentifierRequestType --&gt;
 *     &lt;xs:complexType name="ResolveIdentifierRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="ResolveInput" maxOccurs="unbounded"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class ResolveIdentifierRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = ResolveIdentifierRequest.class.getSimpleName();
    
    // Elements
    private XMLObjectChildrenList<ResolveInput> resolveInputs;
    
    public ResolveIdentifierRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected ResolveIdentifierRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
	public PeopleServiceRequestType type()
    {
    	return PeopleServiceRequestType.RESOLVE_ID_REQUEST;
    }
    
    public XMLObjectChildrenList<ResolveInput> getResolveInputs()
    {
        if(null==resolveInputs) resolveInputs = new XMLObjectChildrenList<ResolveInput>(this);
        return resolveInputs;  
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        if(null!=resolveInputs) children.addAll(resolveInputs);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ResolveIdentifierRequest>
    {
        @Override
        public ResolveIdentifierRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ResolveIdentifierRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            ResolveIdentifierRequest object = (ResolveIdentifierRequest) parentXMLObject;     
            
            if(childXMLObject instanceof ResolveInput)
            {
                object.getResolveInputs().add((ResolveInput) childXMLObject);
            }            

        }
        
    }
    
}