package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ims.MappingInput;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.security.TokenPolicy;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of ResolveInput element --&gt;
 *     &lt;xs:element name="ResolveInput" type="ResolveInputType"/&gt;
 *     &lt;!-- Definition of ResolveInputType --&gt;
 *     &lt;xs:complexType name="ResolveInputType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ims:MappingInputType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class ResolveInput extends MappingInput
{
    
    public static final String LOCAL_NAME = "ResolveInput";
    
    // Elements 
    private TargetObjectID targetObjectID;    
    
	public ResolveInput(TargetObjectID targetID, TokenPolicy policy)
	{
		super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.setTargetObjectID(targetID);
        this.setTokenPolicy(policy);
	}
    
    protected ResolveInput(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    
    public TargetObjectID getTargetObjectID()
    {
        return targetObjectID;
    }

    public void setTargetObjectID(TargetObjectID targetObjectID)
    {
        this.targetObjectID = prepareForAssignment(this.targetObjectID, targetObjectID);
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.addAll(super.getOrderedChildren());
        children.add(targetObjectID);

        return Collections.unmodifiableList(children);            
    }
	
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ResolveInput>
    {
        @Override
        public ResolveInput buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ResolveInput(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends MappingInput.Marshaller
    {        
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends MappingInput.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            ResolveInput o = (ResolveInput) parentXMLObject;        
            
            if (childXMLObject instanceof TargetObjectID) 
            {
                o.setTargetObjectID((TargetObjectID) childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }                    
        }
        
    }
    

    
    
}
