package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.PSObject;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of SetObjectInfoRequest element --&gt;
 *     &lt;xs:element name="SetObjectInfoRequest" type="SetObjectInfoRequestType"/&gt;
 *     &lt;!-- Definition of SetObjectInfoRequestType --&gt;
 *     &lt;xs:complexType name="SetObjectInfoRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object" maxOccurs="unbounded"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class SetObjectInfoRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = SetObjectInfoRequest.class.getSimpleName();
    
    // Elements
    private XMLObjectChildrenList<PSObject> objects;
    private Subscription subscription;
    
    public SetObjectInfoRequest()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    public SetObjectInfoRequest(List<PSObject> objects)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.objects = new XMLObjectChildrenList<PSObject>(this);
        this.objects.addAll(objects);
    }
    
    protected SetObjectInfoRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<PSObject> getObjects()
    {
        if(null==objects) objects = new XMLObjectChildrenList<PSObject>(this);
        return objects;
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        if(null!=objects) children.addAll(objects);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<SetObjectInfoRequest>
    {
        @Override
        public SetObjectInfoRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new SetObjectInfoRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            SetObjectInfoRequest object = (SetObjectInfoRequest) parentXMLObject;     
            
            if(childXMLObject instanceof PSObject) 
            {
                object.getObjects().add((PSObject) childXMLObject);
            }
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }
            
        }
        
    }

    
}
