package org.openliberty.xmltooling.ps.request;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * The PS Subscription element is a straight up liberty subs Subscription element.  
 * This class exists within the PS package purely for consistency and simplicity
 * 
 * @author asa
 *
 */
public class Subscription extends org.openliberty.xmltooling.subs.Subscription
{
    
    public Subscription()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }

    public Subscription(String namespaceURI, String localName, String namespacePrefix)
    {
        super(namespaceURI, localName, namespacePrefix);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Subscription>
    {
        @Override
        public Subscription buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Subscription(namespaceURI, localName, namespacePrefix);
        }  
    }
    
    /**
     * Static Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends org.openliberty.xmltooling.subs.Subscription.Unmarshaller
    {        
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends org.openliberty.xmltooling.subs.Subscription.Marshaller
    {        
    }
    
}
