package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre> 
 *     &lt;!-- Declaration of TestMembershipRequest element --&gt;
 *     &lt;xs:element name="TestMembershipRequest" type="TestMembershipRequestType"/&gt;
 *     &lt;!-- Definition of TestMembershipRequestType --&gt;
 *     &lt;xs:complexType name="TestMembershipRequestType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="RequestAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="TargetObjectID" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="sec:Token"/&gt;
 *                     &lt;xs:element ref="Subscription" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * 
 * </pre>
 * @author asa
 *
 */
public class TestMembershipRequest extends RequestAbstractType
{
    
    public static final String LOCAL_NAME = TestMembershipRequest.class.getSimpleName();
    
    // Elements
    private TargetObjectID targetObjectID;
    private Token token;
    private Subscription subscription;

    public TestMembershipRequest(Token token)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.token = token;
    }

//    public TestMembershipRequest()
//    {
//        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
//    }
    
    protected TestMembershipRequest(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public TargetObjectID getTargetObjectID()
    {
        return targetObjectID;
    }    
    
    public void setTargetObjectID(TargetObjectID targetObjectID)
    {
        this.targetObjectID = prepareForAssignment(this.targetObjectID, targetObjectID);
    }
    
    public Token getToken()
    {
        return token;
    }

    public void setToken(Token token)
    {
        this.token = prepareForAssignment(this.token, token);
    }

    public Subscription getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Subscription subscription)
    {
        this.subscription = prepareForAssignment(this.subscription, subscription);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(targetObjectID);
        children.add(token);
        children.add(subscription);

        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<TestMembershipRequest>
    {
        @Override
        public TestMembershipRequest buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new TestMembershipRequest(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends RequestAbstractType.Marshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends RequestAbstractType.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            TestMembershipRequest object = (TestMembershipRequest) parentXMLObject;     
            
            if(childXMLObject instanceof TargetObjectID) 
            {
                object.setTargetObjectID((TargetObjectID) childXMLObject);
            }
            else if(childXMLObject instanceof Token)
            {
                object.setToken((Token) childXMLObject);
            }            
            else if(childXMLObject instanceof Subscription)
            {
                object.setSubscription((Subscription) childXMLObject);
            }

        }
        
    }
    
}