package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.ps.PSObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of AddCollectionResponse element --&gt;
 *     &lt;xs:element name="AddCollectionResponse" type="AddCollectionResponseType"/&gt;
 *     &lt;!-- Definition of AddCollectionResponseType --&gt;
 *     &lt;xs:complexType name="AddCollectionResponseType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ResponseAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class AddCollectionResponse extends ResponseAbstractType
{
    
    public static final String LOCAL_NAME = AddCollectionResponse.class.getSimpleName();
    
    // Elements
    private PSObject object;
        
    protected AddCollectionResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public PSObject getObject()
    {
        return object;
    }

    public void setObject(PSObject object)
    {
        this.object = prepareForAssignment(this.object, object);
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.addAll(super.getOrderedChildren());
        children.add(object);
        
        return Collections.unmodifiableList(children);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<AddCollectionResponse>
    {
        @Override
        public AddCollectionResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new AddCollectionResponse(namespaceURI, localName, namespacePrefix);
        }                
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ResponseAbstractType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            AddCollectionResponse obj = (AddCollectionResponse) parentXMLObject;
                        
            if(childXMLObject instanceof PSObject)
            {
                obj.setObject((PSObject)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
                
        }
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ResponseAbstractType.Marshaller
    {        
    }
    
}