package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.ps.PSObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of AddKnownEntityResponse element --&gt;
 *     &lt;xs:element name="AddKnownEntityResponse" type="AddKnownEntityResponseType"/&gt;
 *     &lt;!-- Definition of AddKnownEntityResponseType --&gt;
 *     &lt;xs:complexType name="AddKnownEntityResponseType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ResponseAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object" minOccurs="0"/&gt;
 *                     &lt;xs:element ref="SPtoPSRedirectURL" minOccurs="0" maxOccurs="1"/&gt;
 *                     &lt;xs:element ref="QueryString" minOccurs="0" maxOccurs="1"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class AddKnownEntityResponse extends ResponseAbstractType
{
    
    public static final String LOCAL_NAME = AddKnownEntityResponse.class.getSimpleName();
    
    // Elements
    private PSObject object;
    private SPtoPSRedirectURL sPtoPSRedirectURL;
    private QueryString queryString;
    
    protected AddKnownEntityResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public PSObject getObject()
    {
        return object;
    }

    public void setObject(PSObject object)
    {
        this.object = prepareForAssignment(this.object, object);
    }

    public QueryString getQueryString()
    {
        return queryString;
    }

    public void setQueryString(QueryString queryString)
    {
        this.queryString = prepareForAssignment(this.queryString, queryString);
    }

    public SPtoPSRedirectURL getSPtoPSRedirectURL()
    {
        return sPtoPSRedirectURL;
    }

    public void setSPtoPSRedirectURL(SPtoPSRedirectURL sPtoPSRedirectURL)
    {
        sPtoPSRedirectURL = prepareForAssignment(this.sPtoPSRedirectURL, sPtoPSRedirectURL);
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.addAll(super.getOrderedChildren());
        children.add(object);
        children.add(sPtoPSRedirectURL);
        children.add(queryString);
        
        return Collections.unmodifiableList(children);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<AddKnownEntityResponse>
    {
        @Override
        public AddKnownEntityResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new AddKnownEntityResponse(namespaceURI, localName, namespacePrefix);
        }                
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ResponseAbstractType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            AddKnownEntityResponse obj = (AddKnownEntityResponse) parentXMLObject;
                        
            if(childXMLObject instanceof PSObject)
            {
                obj.setObject((PSObject)childXMLObject);
            }
            else if(childXMLObject instanceof SPtoPSRedirectURL)
            {
                obj.setSPtoPSRedirectURL((SPtoPSRedirectURL)childXMLObject);
            }
            else if(childXMLObject instanceof QueryString)
            {
                obj.setQueryString((QueryString)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
                
        }
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ResponseAbstractType.Marshaller
    {        
    }
    
}