package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.ps.PSObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of QueryObjectsResponse element --&gt;
 *     &lt;xs:element name="QueryObjectsResponse" type="QueryObjectsResponseType"/&gt;
 *     &lt;!-- Definition of QueryObjectsResponseType --&gt;
 *     &lt;xs:complexType name="QueryObjectsResponseType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ResponseAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="Object" minOccurs="0" maxOccurs="unbounded"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class QueryObjectsResponse extends ResponseAbstractType
{
    
    public static final String LOCAL_NAME = QueryObjectsResponse.class.getSimpleName();
    
    // Elements
    private XMLObjectChildrenList<PSObject> objects;
        
    protected QueryObjectsResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<PSObject> getObjects()
    {
        if(null==objects) objects = new XMLObjectChildrenList<PSObject>(this);
        return objects;
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.addAll(super.getOrderedChildren());
        if(null!=objects) children.addAll(objects);
        
        return Collections.unmodifiableList(children);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<QueryObjectsResponse>
    {
        @Override
        public QueryObjectsResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new QueryObjectsResponse(namespaceURI, localName, namespacePrefix);
        }                
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ResponseAbstractType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            QueryObjectsResponse obj = (QueryObjectsResponse) parentXMLObject;
                        
            if(childXMLObject instanceof PSObject)
            {
                obj.getObjects().add((PSObject)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
                
        }
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ResponseAbstractType.Marshaller
    {        
    }
    
}