package org.openliberty.xmltooling.ps.response;

import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;

/**
 * A PS provider may insert a QueryString in its AddEntityResponse or AddKnownEntityResponse. The invited Principal 
 * can present this artifact string to a certain provider.
 * <p>
 * The &lt;QueryString&gt; element enables an alternative model for invited user interaction which is expected to better
 * defend against identity theft attacks in which a valid email is spoofed to fool users into clicking an embedded
 * URL. The invitation received by the invited user will contain a string carrying a SAML artifact (and potentially
 * relay state info) representing a SAML &lt;samlp:AuthnRequest&gt; message created by the PS provider. The invited
 * user can, if they choose, present this artifact string to their identity provider - which can then use the SAML
 * &lt;samlp:ArtifactResolve&gt; message to retrieve the original &lt;samlp:AuthnRequest&gt; message from the PS
 * provider.
 * </p>
 * <p>
 * As the invited user visits their IDP by explicitly providing the address or using an existing bookmark, they can be more
 * confident that the site is not spoofed. Once they are at their IDP and after presenting the SAML artifact , appropriate
 * federations can be established for the invited user with the originating PS provider and SP.
 * </p>
 * <pre>
 *     &lt;!-- Declaration of QueryString --&gt;
 * 
 *     &lt;xs:element name="QueryString" type="QueryStringType"/&gt;
 * 
 *     &lt;!-- Definition of QueryStringType--&gt;
 * 
 *     &lt;xs:complexType name="QueryStringType"&gt;
 *         &lt;xs:annotation&gt;
 *             &lt;xs:documentation&gt;A PS provider may insert a QueryString in its AddEntityResponse or AddKnownEntityResponse. The invited Principal can present this artifact string to a certain provider.&lt;/xs:documentation&gt;
 *         &lt;/xs:annotation&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:string"/&gt;
 *         &lt;/xs:simpleContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class QueryString extends XSStringImpl
{
    public static final String LOCAL_NAME = "QueryString";

    protected QueryString(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<QueryString>
    {
        @Override
        public QueryString buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new QueryString(namespaceURI, localName, namespacePrefix);
        }        
    }

    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSStringMarshaller
    {
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSStringUnmarshaller
    {        
    }



}
