package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * <pre>
 *     &lt;!-- Declaration of ResolveIdentifierResponse element --&gt;
 *     &lt;xs:element name="ResolveIdentifierResponse" type="ResolveIdentifierResponseType"/&gt;
 *     &lt;!-- Definition of ResolveIdentifierResponseType --&gt;
 *     &lt;xs:complexType name="ResolveIdentifierResponseType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ResponseAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element ref="ResolveOutput" maxOccurs="unbounded"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * 
 * </pre>
 * @author asa
 *
 */
public class ResolveIdentifierResponse extends ResponseAbstractType
{
    
    public static final String LOCAL_NAME = ResolveIdentifierResponse.class.getSimpleName();
    
    // Elements
    private XMLObjectChildrenList<ResolveOutput> resolveOutputs;
        
    protected ResolveIdentifierResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public XMLObjectChildrenList<ResolveOutput> getResolveOutputs()
    {
        if(null==resolveOutputs) resolveOutputs = new XMLObjectChildrenList<ResolveOutput>(this);
        return resolveOutputs;
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.addAll(super.getOrderedChildren());
        if(null!=resolveOutputs) children.addAll(resolveOutputs);
        
        return Collections.unmodifiableList(children);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ResolveIdentifierResponse>
    {
        @Override
        public ResolveIdentifierResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ResolveIdentifierResponse(namespaceURI, localName, namespacePrefix);
        }                
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ResponseAbstractType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            ResolveIdentifierResponse obj = (ResolveIdentifierResponse) parentXMLObject;
                        
            if(childXMLObject instanceof ResolveOutput)
            {
                obj.getResolveOutputs().add((ResolveOutput)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
                
        }
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ResponseAbstractType.Marshaller
    {        
    }
    
}