package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * This is the base type for most PS responses.
 * 
 * <pre>
 *     &lt;!-- Definition of ResponseAbstractType --&gt;
 *     &lt;xs:complexType name="ResponseAbstractType" abstract="true"&gt;
 *      &lt;xs:sequence&gt;
 *             &lt;xs:element ref="lu:Status"/&gt;
 *      &lt;/xs:sequence&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public abstract class ResponseAbstractType extends AbstractXMLObject implements AttributeExtensibleXMLObject
{

    // Attributes
    private AttributeMap otherAttributes;

    // Element
    private Status status;

    protected ResponseAbstractType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Status getStatus()
    {
        return status;
    }

    public void setStatus(Status status)
    {
        this.status = prepareForAssignment(this.status, status);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(status);

        return Collections.unmodifiableList(children);
    }
    
    public AttributeMap getUnknownAttributes()
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }


    /**
     * Internal marshaller, placing attribute values into the DOM
     * @author asa
     *
     */
    public abstract static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            ResponseAbstractType obj = (ResponseAbstractType)xmlObject;

            // marshall the unknown attributes (supported by RequestType)
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }

    /**
     * Internal unmarshaller, placing DOM atts into the XMLObject
     * and connecting child elements
     * 
     * @author asa
     *
     */
    public abstract static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            ResponseAbstractType obj = (ResponseAbstractType) xmlObject;

            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            ResponseAbstractType obj = (ResponseAbstractType) parentXMLObject;
            if(childXMLObject instanceof Status)
            {
                obj.setStatus((Status)childXMLObject);
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }


    }




}