package org.openliberty.xmltooling.ps.response;

import java.util.List;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *     &lt;!-- Definition of ResultType --&gt; 
 *     &lt;xs:complexType name="ResultType"&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:boolean"/&gt;
 *         &lt;/xs:simpleContent&gt;
 *     &lt;/xs:complexType&gt;
 * 
 * </pre>
 * @author asa
 *
 */
public class Result extends AbstractXMLObject
{

    // Element Content
    private Boolean value;
    
    protected Result(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

        
    public Boolean getValue()
    {
        return value;
    }


    public void setValue(Boolean value)
    {
        this.value = prepareForAssignment(this.value, value);
    }


    public List<XMLObject> getOrderedChildren()
    {        
        return null;
    }
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Result>
    {
        @Override
        public Result buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Result(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            // no atts            
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            // no children            
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            Result obj = (Result)xmlObject;
            obj.setValue(OpenLibertyHelpers.booleanFromString(elementContent));
        }
        
    }
    
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no atts
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Result obj = (Result)xmlObject;
            Boolean result = obj.getValue();
            if(null!=result)
            {
                ElementSupport.appendTextContent(domElement, OpenLibertyHelpers.stringFromBoolean(result, OpenLibertyHelpers.FALSE_STR));  
            }
        }
        
    }
    
    

}
