package org.openliberty.xmltooling.ps.response;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSURIImpl;
import org.opensaml.core.xml.schema.impl.XSURIMarshaller;
import org.opensaml.core.xml.schema.impl.XSURIUnmarshaller;

/**
 * The PS provider MAY use the &lt;SPtoPSRedirectURL&gt; element on &lt;AddEntityResponse&gt; and
 * &lt;AddKnownEntityResponse&gt; messages to specify to the SP the URL (at the PS provider) to which that PS
 * desires the invited user�s user agent be directed after successful initial interaction at the SP has occurred. If and when
 * the invited user�s user agent is sent to this URL, the PS provider will endeavour to establish a federation for that
 * principal with the appropriate IDP.
 * </p>
 * <p>
 * The value of the &lt;SPtoPSRedirectURL&gt; element MUST be such that, if and when a user agent is sent to this address
 * from the SP, the PS can unambiguously determine the invitation to which the URL corresponds. The URL MUST be
 * unique for each combination of the inviting user (that owns the PS resource), the requesting SP, and the invited user.
 * </p>
 * <p>
 * The PS provider MUST be prepared for the invited user to, at some point in the future, visit the URL provided in
 * any specified &lt;SPtoPSRedirectURL&gt; element. As it may be some time before the invited user does respond, the PS
 * provider SHOULD store this url for a reasonable length of time.
 * </p>
 * <p>
 * <pre>
 *     &lt;!-- Declaration of SPtoPSRedirectURL--&gt;
 * 
 *     &lt;xs:element name="SPtoPSRedirectURL" type="SPtoPSRedirectURLType"/&gt;
 * 
 *     &lt;!-- Definition of SPtoPSRedirectURLType--&gt;
 * 
 *     &lt;xs:complexType name="SPtoPSRedirectURLType"&gt;
 *         &lt;xs:annotation&gt;
 *             &lt;xs:documentation&gt;A PS provider may insert a SPtoPSRedirectURL in its AddEntityResponse. It will be to this URL that the invited principal will be sent after responding to the invitation. &lt;/xs:documentation&gt;
 *         &lt;/xs:annotation&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:anyURI"/&gt;
 *         &lt;/xs:simpleContent&gt;
 *     &lt;/xs:complexType&gt;
 *     </pre>
 * </p>
 * @author asa
 *
 */
public class SPtoPSRedirectURL extends XSURIImpl
{

    public static String LOCAL_NAME = "SPtoPSRedirectURL";

    public SPtoPSRedirectURL()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    protected SPtoPSRedirectURL(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<SPtoPSRedirectURL>
    {
        @Override
        public SPtoPSRedirectURL buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new SPtoPSRedirectURL(namespaceURI, localName, namespacePrefix);
        }
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSURIMarshaller
    {        
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSURIUnmarshaller
    {        
    }
    
    
}