package org.openliberty.xmltooling.ps.response;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * <pre>
 *     &lt;!-- Declaration of TestMembershipResponse element --&gt;
 *     &lt;xs:element name="TestMembershipResponse" type="TestMembershipResponseType"/&gt;
 *     &lt;!-- Definition of TestMembershipResponseType --&gt;
 *     &lt;xs:complexType name="TestMembershipResponseType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="ResponseAbstractType"&gt;
 *                 &lt;xs:sequence&gt;
 *                     &lt;xs:element name="Result" type="ResultType" minOccurs="0"/&gt;
 *                 &lt;/xs:sequence&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class TestMembershipResponse extends ResponseAbstractType
{
    
    public static final String LOCAL_NAME = TestMembershipResponse.class.getSimpleName();
    
    // Elements
    private Result result;
        
    protected TestMembershipResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Result getResult()
    {
        return result;
    }

    public void setResult(Result result)
    {
        this.result = prepareForAssignment(this.result, result);
    }

    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.addAll(super.getOrderedChildren());
        children.add(result);
        
        return Collections.unmodifiableList(children);
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<TestMembershipResponse>
    {
        @Override
        public TestMembershipResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new TestMembershipResponse(namespaceURI, localName, namespacePrefix);
        }                
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ResponseAbstractType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            TestMembershipResponse obj = (TestMembershipResponse) parentXMLObject;
                        
            if(childXMLObject instanceof Result)
            {
                obj.setResult((Result)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
                
        }
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ResponseAbstractType.Marshaller
    {        
    }
    
}