/**
 * 
 */
package org.openliberty.xmltooling.sasl;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * @author tguion
 *
 */
public class SASLRequestMarshaller extends AbstractSAMLObjectMarshaller {

    /**
     * Constructor.
     *
    public SASLRequestMarshaller() 
    {
        // A.H. 2008.12.17 - commented out when upgrading to SAML 2.2.2
        // super(SASLConstants.NAMESPACE, SASLRequest.DEFAULT_ELEMENT_LOCAL_NAME);
    }
    */

	/**
     * No-op method. Extending implementations should override this method if they have attributes to marshall into the
     * Element.
     * 
     * {@inheritDoc}
     */
    @Override
	protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
		SASLRequest saslRequest = (SASLRequest) xmlObject;

        if (saslRequest.getMechanism() != null) {
            domElement.setAttributeNS(null, SASLRequest.MECHANISM_ATTRIB_NAME, saslRequest.getMechanism());
        }
        
        if (saslRequest.getAuthzID() != null) {
            domElement.setAttributeNS(null, SASLRequest.AUTHZID_ATTRIB_NAME, saslRequest.getAuthzID());
        }

        if (saslRequest.getAdvisoryAuthnID() != null) {
            domElement.setAttributeNS(null, SASLRequest.ADVISORYAUTHNID_ATTRIB_NAME, saslRequest.getAdvisoryAuthnID());
        }
        
        Attr attr;
        for(Entry<QName, String> entry: saslRequest.getUnknownAttributes().entrySet()){
            attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attr.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attr);
            if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || saslRequest.getUnknownAttributes().isIDAttribute(entry.getKey())) {
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }
    }

}
