/**
 * 
 */
package org.openliberty.xmltooling.sasl;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.w3c.dom.Attr;

/**
 * @author tguion
 *
 */
public class SASLRequestUnmarshaller extends AbstractXMLObjectUnmarshaller {

    /**
     * Constructor.
     *
    public SASLRequestUnmarshaller() 
    {
    	super(SASLConstants.NAMESPACE, SASLRequest.DEFAULT_ELEMENT_LOCAL_NAME);
    }
    */
	
	
	
    /**
     * {@inheritDoc}
     */
    @Override
	protected void processChildElement(XMLObject parentObject, XMLObject childObject)
            throws UnmarshallingException {
    	SASLRequest saslRequest = (SASLRequest) parentObject;

        if (childObject instanceof Data) {
        	saslRequest.setData((Data) childObject);
        } else if (childObject instanceof RequestedAuthnContext) {
        	saslRequest.setRequestedAuthnContext((RequestedAuthnContext) childObject);
        } else if (childObject instanceof Extensions) {
        	saslRequest.setExtensions((Extensions) childObject);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
	protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
    	SASLRequest saslRequest = (SASLRequest) samlObject;

        if (attribute.getLocalName().equals(SASLRequest.MECHANISM_ATTRIB_NAME)) {
        	saslRequest.setMechanism(attribute.getValue());
        } else if (attribute.getLocalName().equals(SASLRequest.AUTHZID_ATTRIB_NAME)) {
        	saslRequest.setAuthzID(attribute.getValue());
        } else if (attribute.getLocalName().equals(SASLRequest.ADVISORYAUTHNID_ATTRIB_NAME)) {
        	saslRequest.setAdvisoryAuthnID(attribute.getValue());
        } else {
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) {
            	saslRequest.getUnknownAttributes().registerID(attribQName);
            }
            saslRequest.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }

	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) {
		// no element content
	}
    
}
