package org.openliberty.xmltooling.sasl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.utility_2_0.Status;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class SASLResponse  extends AbstractSignableXMLObject implements ElementExtensibleXMLObject
{
	
	public static String DEFAULT_ELEMENT_LOCAL_NAME = "SASLResponse";
	
	public static final QName DEFAULT_ELEMENT_NAME = new QName(SASLConstants.NAMESPACE, DEFAULT_ELEMENT_LOCAL_NAME, SASLConstants.NAMESPACE_PREFIX);

	// public static String NAMESPACE = "urn:liberty:sa:2006-08";
	// public static String NAMESPACE_PREFIX = "sasl";
	
	
	// Elements
    private org.openliberty.xmltooling.utility_2_0.Status status;
    private EndpointReference epr;
    private Data data;
	private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;
	
	// Attribute
	private String serverMechanism;
    
	// Attribute Name
	public static String ATT_SERVER_MECHANISM = "serverMechanism";
	
	
	protected SASLResponse(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
		
	}

	public List<XMLObject> getUnknownXMLObjects() 
	{				
		return unknownXMLObjects;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }
    
	public List<XMLObject> getOrderedChildren() 
	{
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(status);
        children.add(epr);        
        children.add(data);        
        children.addAll(unknownXMLObjects);
        
        return Collections.unmodifiableList(children);
	}	

    
    public Status getStatus() 
    { 
        return this.status; 
    }
    
    public void setStatus(Status status) 
    {
    	this.status = prepareForAssignment(this.status, status);
    }
    
    
    public Data getData() 
    { 
        return this.data; 
    }

    public void setData(Data data) 
    {
        this.data = prepareForAssignment(this.data, data);
    }
    
    public String getServerMechanism() 
    { 
    	return this.serverMechanism; 
    }

    public void setServerMechanism(String serverMechanism) 
    {
    	this.serverMechanism = prepareForAssignment(this.serverMechanism, serverMechanism);
    }


    public void setEndpointReference(EndpointReference epr) 
    {
    	this.epr = prepareForAssignment(this.epr, epr);
    }
    
    public EndpointReference getEndpointReference() 
    { 
    	return this.epr; 
    }

}