package org.openliberty.xmltooling.sasl;

import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class SASLResponseUnmarshaller  extends AbstractXMLObjectUnmarshaller
{
    
	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	{
		SASLResponse response = (SASLResponse) xmlObject;

        if (attribute.getLocalName().equals(SASLResponse.ATT_SERVER_MECHANISM)) 
        {
        	response.setServerMechanism(attribute.getValue());
        }

	}

	
	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	{	
		SASLResponse saslresponse = (SASLResponse) parentXMLObject;		
		
        if (childXMLObject instanceof org.openliberty.xmltooling.utility_2_0.Status) 
        {
        	saslresponse.setStatus((org.openliberty.xmltooling.utility_2_0.Status) childXMLObject);
        }
        else if(childXMLObject instanceof EndpointReference)
        {
        	saslresponse.setEndpointReference((EndpointReference) childXMLObject);
        }
        else if(childXMLObject instanceof Data)
        {
            saslresponse.setData((Data) childXMLObject);
        }
        else
        {
        	saslresponse.getUnknownXMLObjects().add(childXMLObject);
        }	
	}
	
	
	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
	{
		// NO CONTENT
	}
}
