package org.openliberty.xmltooling.sasl;

import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

// TODO: Move out of this package into a utility package

public class Status extends AbstractSignableXMLObject
{
	/**
	 * @author tguion
	 * (see liberty-idwsf-soap-binding-2.0-errata-v1.0.pdf)
	 */
	public enum StatusCode {
		INVALIDACTOR("InvalidActor", "There is an issue with the actor attribute on the indicated header block in the indicated message.", "C"),
		INVALIDMUSTUNDERSTAND("InvalidMustUnderstand", "There is an issue with the mustUnderstand attribute on the indicated header block in the indicated message.", "C"); 
		// TODO: complete from referenced table in spec
		
		private final String code;
		private final String semantics;
		private final String source;
		
		StatusCode(String code, String semantics, String source) {
			this.code = code;
			this.semantics = semantics;
			this.source = source;
		}
		
		public boolean isClientSource() { return "C".equals(source); }
		public boolean isServerSource() { return "S".equals(source); }

		/**
		 * @return the code
		 */
		public String getCode() {
			return code;
		}

		/**
		 * @return the semantics
		 */
		public String getSemantics() {
			return semantics;
		}

		/**
		 * @return the source
		 */
		public String getSource() {
			return source;
		}
	}

	public static final String DEFAULT_ELEMENT_LOCAL_NAME = "Status";
	
	public static QName DEFAULT_ELEMENT_NAME = new QName(Konstantz.LU_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.LU_PREFIX);
	
	public static String ATT_CODE = "code";
	
	public static String ATT_REF = "ref";
	
	public static String ATT_COMMENT = "comment";
	
	public static final String CONTINUE = "Continue";
	
	public static final String OK = "OK";
	
	/**
	 * Required code attribute
	 */
	private String code;
	
	/**
	 * Optional ref attribute
	 */
	private String ref;
	
	/**
	 * Optional comment attribute
	 */
	private String comment;
	
	protected Status(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}
	
    public void setCode(String code) 
    {
    	this.code = prepareForAssignment(this.code, code);
    }
    
    public String getCode() 
    { 
    	return code; 
    }

	/**
	 * @return the comment
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * @param comment the comment to set
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}

	/**
	 * @return the ref
	 */
	public String getRef() {
		return ref;
	}

	/**
	 * @param ref the ref to set
	 */
	public void setRef(String ref) {
		this.ref = ref;
	}
	
	public List<XMLObject> getOrderedChildren() {
		// no children
		return null;
	}

}
