package org.openliberty.xmltooling.sasl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class StatusMarshaller extends AbstractXMLObjectMarshaller
{

	public StatusMarshaller() 
	{
		super();
	}
	
	
	@Override
	protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
	{
		Status status = (Status)xmlObject;
		
		if(status.getCode() != null)
		{
			domElement.setAttributeNS(null, Status.ATT_CODE, status.getCode());
		}
	}


	@Override
	protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
	{
		// NO TEXT CONTENT		
	}


}
