package org.openliberty.xmltooling.sasl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class StatusUnmarshaller extends AbstractXMLObjectUnmarshaller
{
	
	/*
    public StatusUnmarshaller()
    {
        super(Konstantz.LU_NS, Status.DEFAULT_ELEMENT_LOCAL_NAME);
    }
    */
    
	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	{
		Status status = (Status) xmlObject;

        if (attribute.getLocalName().equals(Status.ATT_CODE)) 
        {
        	status.setCode(attribute.getValue());
        } else if (attribute.getLocalName().equals(Status.ATT_REF)) 
        {
        	status.setRef(attribute.getValue());
        } else if (attribute.getLocalName().equals(Status.ATT_COMMENT)) 
        {
        	status.setComment(attribute.getValue());
        }	        
	}

	
	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	{	
		// NO CHILD ELEMENTS                
	}

	
	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
	{
		// NO CONTENT
	}
}
