/*
 * Copyright [2006] [University Corporation for Advanced Internet Development, Inc.]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openliberty.xmltooling.soap.soap11;

import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.util.SOAPConstants;

/**
 * Builder of {@link org.opensaml.ws.soap.soap11.impl.BodyImpl} objects.
 */
public class BodyBuilder extends AbstractXMLObjectBuilder<Body> implements SOAPObjectBuilder<Body> {

    /**
     * Creates an envelope object with the default SOAP 1.1 namespace, prefix and "Body" as the element local name.
     * 
     * @return the build Envelope object
     */
    public Body buildObject(){
        return buildObject(SOAPConstants.SOAP11_NS, Body.DEFAULT_ELEMENT_LOCAL_NAME, SOAPConstants.SOAP11_PREFIX);
    }
    
    /** {@inheritDoc} */
    @Override
	public Body buildObject(String namespaceURI, String localName, String namespacePrefix) {
        return new BodyImpl(namespaceURI, localName, namespacePrefix);
    }
}