/*
 * Copyright [2006] [University Corporation for Advanced Internet Development, Inc.]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openliberty.xmltooling.soap.soap11;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.soapbinding.ApplicationEPR;
import org.openliberty.xmltooling.soapbinding.Consent;
import org.openliberty.xmltooling.soapbinding.EndpointUpdate;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.soapbinding.ProcessingContext;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.openliberty.xmltooling.soapbinding.TargetIdentity;
import org.openliberty.xmltooling.soapbinding.Timeout;
import org.openliberty.xmltooling.soapbinding.UsageDirective;
import org.openliberty.xmltooling.soapbinding.UserInteraction;
import org.openliberty.xmltooling.wsa.Action;
import org.openliberty.xmltooling.wsa.CredentialsContext;
import org.openliberty.xmltooling.wsa.FaultTo;
import org.openliberty.xmltooling.wsa.MessageID;
import org.openliberty.xmltooling.wsa.RelatesTo;
import org.openliberty.xmltooling.wsa.ReplyTo;
import org.openliberty.xmltooling.wsa.To;
import org.openliberty.xmltooling.wsse.Security;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.soap.common.AbstractExtensibleSOAPObject;
import org.opensaml.soap.soap11.Header;

/**
 * Concrete implementation of {@link org.opensaml.ws.soap.soap11.Header}.
 */
public class HeaderIDWSF extends AbstractExtensibleSOAPObject implements Header 
{

    // Elements
    private MessageID   messageID;  // wsa
    private RelatesTo   relatesTo;  // wsa  
    private To          to;         // wsa
    private Action      action;     // wsa
    private ReplyTo   replyTo;      // wsa
    private FaultTo   faultTo;    // wsa
    private Security	security;   // wsse
    private Framework   framework;  // sbf
    private Sender sender;
    private TargetIdentity targetIdentity;
    private ProcessingContext processingContext;
    private Consent consent;
    private UsageDirective usageDirective;
    private EndpointUpdate endpointUpdate;
    private Timeout timeout;
    private CredentialsContext credentialsContext;
    private ApplicationEPR applicationEPR; // can there be more than one?
    private UserInteraction userInteraction; // can there be more than one?

    /**
     * Constructor.
     * 
     * @param namespaceURI namespace of the element
     * @param elementLocalName name of the element
     * @param namespacePrefix namespace prefix of the element
     */
    protected HeaderIDWSF(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public void setFramework(Framework framework)
    {
        this.framework = prepareForAssignment(this.framework, framework);
    }

    public Framework getFramework()
    {
        return framework;
    }

    public MessageID getMessageID()
    {
        return messageID;
    }

    public void setMessageID(MessageID messageID)
    {
        this.messageID = prepareForAssignment(this.messageID, messageID);
    }

    public To getTo()
    {
        return to;
    }

    public void setTo(To to)
    {
        this.to = prepareForAssignment(this.to, to);
    }

    public ReplyTo getReplyTo()
    {
        return replyTo;
    }

    public void setReplyTo(ReplyTo replyTo)
    {
        this.replyTo = prepareForAssignment(this.replyTo, replyTo);
    }

    public FaultTo getFaultTo()
    {
        return faultTo;
    }

    public void setFaultTo(FaultTo faultTo)
    {
        this.faultTo = prepareForAssignment(this.faultTo, faultTo);
    }

    public Sender getSender()
    {
        return sender;
    }

    public void setSender(Sender sender)
    {
        this.sender = prepareForAssignment(this.sender, sender);
    }

    public TargetIdentity getTargetIdentity()
    {
        return targetIdentity;
    }

    public void setTargetIdentity(TargetIdentity targetIdentity)
    {
        this.targetIdentity = prepareForAssignment(this.targetIdentity, targetIdentity);
    }

    public Consent getConsent()
    {
        return consent;
    }

    public void setConsent(Consent consent)
    {
        this.consent = prepareForAssignment(this.consent, consent);
    }

    public UsageDirective getUsageDirective()
    {
        return usageDirective;
    }

    public void setUsageDirective(UsageDirective usageDirective)
    {
        this.usageDirective = prepareForAssignment(this.usageDirective, usageDirective);
    }

    public EndpointUpdate getEndpointUpdate()
    {
        return endpointUpdate;
    }

    public void setEndpointUpdate(EndpointUpdate endpointUpdate)
    {
        this.endpointUpdate = prepareForAssignment(this.endpointUpdate, endpointUpdate);
    }

    public Timeout getTimeout()
    {
        return timeout;
    }

    public void setTimeout(Timeout timeout)
    {
        this.timeout = prepareForAssignment(this.timeout, timeout);
    }

    public ApplicationEPR getApplicationEPR()
    {
        return applicationEPR;
    }

    public void setApplicationEPR(ApplicationEPR applicationEPR)
    {
        this.applicationEPR = prepareForAssignment(this.applicationEPR, applicationEPR);
    }

    public UserInteraction getUserInteraction()
    {
        return userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction)
    {
        this.userInteraction = prepareForAssignment(this.userInteraction, userInteraction);
    }

    public RelatesTo getRelatesTo()
    {
        return relatesTo;
    }

    public void setRelatesTo(RelatesTo relatesTo)
    {
        this.relatesTo = prepareForAssignment(this.relatesTo, relatesTo);
    }

    public Action getAction()
    {
        return action;
    }

    public void setAction(Action action)
    {
        this.action = prepareForAssignment(this.action, action);
    }

    public Security getSecurity()
    {
        return security;
    }

    public void setSecurity(Security security)
    {
        this.security = prepareForAssignment(this.security, security);
    }

    public ProcessingContext getProcessingContext()
    {
        return processingContext;
    }

    public void setProcessingContext(ProcessingContext security)
    {
        this.processingContext = prepareForAssignment(this.processingContext, processingContext);
    }

    public CredentialsContext getCredentialsContext()
    {
        return credentialsContext;
    }

    public void setCredentialsContext(CredentialsContext credentialsContext)
    {
        this.credentialsContext = prepareForAssignment(this.credentialsContext, credentialsContext);
    }  

    @Override
	public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(action);
        children.add(applicationEPR);
        children.add(consent);
        children.add(credentialsContext);
        children.add(endpointUpdate);
        children.add(framework);
        children.add(messageID);
        children.add(processingContext);
        children.add(relatesTo);
        children.add(replyTo);
        children.add(faultTo);
        children.add(security);
        children.add(sender);
        children.add(targetIdentity);
        children.add(timeout);
        children.add(to);
        children.add(usageDirective);
        children.add(userInteraction);
        
        children.addAll(getUnknownXMLObjects());

        return Collections.unmodifiableList(children);
    }


    
    


}
