/*
 * Copyright [2006] [University Corporation for Advanced Internet Development, Inc.]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.openliberty.xmltooling.soap.soap11;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.soapbinding.ApplicationEPR;
import org.openliberty.xmltooling.soapbinding.Consent;
import org.openliberty.xmltooling.soapbinding.EndpointUpdate;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.soapbinding.ProcessingContext;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.openliberty.xmltooling.soapbinding.TargetIdentity;
import org.openliberty.xmltooling.soapbinding.Timeout;
import org.openliberty.xmltooling.soapbinding.UsageDirective;
import org.openliberty.xmltooling.soapbinding.UserInteraction;
import org.openliberty.xmltooling.wsa.Action;
import org.openliberty.xmltooling.wsa.CredentialsContext;
import org.openliberty.xmltooling.wsa.FaultTo;
import org.openliberty.xmltooling.wsa.MessageID;
import org.openliberty.xmltooling.wsa.RelatesTo;
import org.openliberty.xmltooling.wsa.ReplyTo;
import org.openliberty.xmltooling.wsa.To;
import org.openliberty.xmltooling.wsse.Security;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.soap11.Header;
import org.w3c.dom.Attr;

/**
 * A thread-safe unmarshaller for {@link org.opensaml.ws.soap.soap11.Header}s.
 */
public class HeaderUnmarshaller extends AbstractXMLObjectUnmarshaller 
{

    /** {@inheritDoc} */
    @Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
    {
    	HeaderIDWSF header = (HeaderIDWSF) parentXMLObject;
        		
        if (childXMLObject instanceof Action)                   header.setAction((Action) childXMLObject);
        else if (childXMLObject instanceof ApplicationEPR)      header.setApplicationEPR((ApplicationEPR) childXMLObject);
        else if (childXMLObject instanceof Consent)             header.setConsent((Consent) childXMLObject);
        else if (childXMLObject instanceof CredentialsContext)  header.setCredentialsContext((CredentialsContext) childXMLObject);
        else if (childXMLObject instanceof EndpointUpdate)      header.setEndpointUpdate((EndpointUpdate) childXMLObject);
        else if (childXMLObject instanceof Framework)           header.setFramework((Framework) childXMLObject);
        else if (childXMLObject instanceof MessageID)           header.setMessageID((MessageID) childXMLObject);
        else if (childXMLObject instanceof ProcessingContext)   header.setProcessingContext((ProcessingContext) childXMLObject);        
        else if (childXMLObject instanceof RelatesTo)           header.setRelatesTo((RelatesTo) childXMLObject);
        else if (childXMLObject instanceof ReplyTo)             header.setReplyTo((ReplyTo) childXMLObject);
        else if (childXMLObject instanceof FaultTo)             header.setFaultTo((FaultTo) childXMLObject);
        else if (childXMLObject instanceof Security)            header.setSecurity((Security) childXMLObject);
        else if (childXMLObject instanceof Sender)              header.setSender((Sender) childXMLObject);
        else if (childXMLObject instanceof TargetIdentity)      header.setTargetIdentity((TargetIdentity) childXMLObject);
        else if (childXMLObject instanceof Timeout)             header.setTimeout((Timeout) childXMLObject);
        else if (childXMLObject instanceof To)                  header.setTo((To) childXMLObject);
        else if (childXMLObject instanceof UsageDirective)      header.setUsageDirective((UsageDirective) childXMLObject);
        else if (childXMLObject instanceof UserInteraction)     header.setUserInteraction((UserInteraction) childXMLObject);
        else
        {
        	header.getUnknownXMLObjects().add(childXMLObject);
        }

    }
    
    /** {@inheritDoc} */
    @Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
    {
        Header header = (Header) xmlObject;
        QName attribQName = QNameSupport.constructQName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix());
        if (attribute.isId()) 
        {
            header.getUnknownAttributes().registerID(attribQName);
        }
        header.getUnknownAttributes().put(attribQName, attribute.getValue());
    }

    /** {@inheritDoc} */
    @Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // do nothing, no child content
    }

}