package org.openliberty.xmltooling.soapbinding;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.EndpointReferenceMarshaller;
import org.openliberty.xmltooling.wsa.EndpointReferenceUnmarshaller;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * This header may be included in a message zero or more times and provides a means for a sender to 
 * specify application endpoints that may be referenced from the SOAP Body of the message.
 * <p>
 * <pre>
 *      &lt;xs:element name="ApplicationEPR" type="wsa:EndpointReferenceType"/&gt;
 * </pre>
 * </p>
 * @author asa
 *
 */
public class ApplicationEPR extends EndpointReference implements AttributeExtensibleXMLObject
{

    public static final String LOCAL_NAME = "ApplicationEPR";

    /**
     * Support for AttributeExtensibleXMLObject interface
     */
    private AttributeMap otherAttributes;

    public ApplicationEPR()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }

    public ApplicationEPR(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }  


    public AttributeMap getUnknownAttributes() 
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }


    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends EndpointReferenceUnmarshaller
    {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            ApplicationEPR epr = (ApplicationEPR) xmlObject;

            if(attribute.getLocalName().equals(EndpointReference.ATT_ID) || attribute.getLocalName().equals(EndpointReference.ATT_NOT_ON_OR_AFTER))
            {
                super.processAttribute(xmlObject, attribute);
            }
            else
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) {
                    epr.getUnknownAttributes().registerID(attribQName);
                }
                epr.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }
    }

    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends EndpointReferenceMarshaller 
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {

            super.marshallAttributes(xmlObject, domElement);

            ApplicationEPR epr = (ApplicationEPR)xmlObject;

            Attr attr;
            for(Entry<QName, String> entry: epr.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || epr.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }

        }
    }


    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ApplicationEPR>
    {
        @Override
        public ApplicationEPR buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new ApplicationEPR(namespaceURI, localName, namespacePrefix);
        }        
    }



}
