package org.openliberty.xmltooling.soapbinding;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * This header block is used to explicitly claim that the Principal consented to the present interaction.
 * <p>
 * 
 * </p>
 * <p>
 * <pre>
 *   &lt;xs:complexType name="ConsentType"&gt;
 *     &lt;xs:attribute name="uri" type="xs:anyURI" use="required"/&gt;
 *     &lt;xs:attribute name="timestamp" type="xs:dateTime" use="optional"/&gt;
 *     &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *   &lt;/xs:complexType&gt;
 * 
 *   &lt;xs:element name="Consent" type="ConsentType"/&gt;
 * </pre>
 * </p>
 * @author asa
 *
 */
public class Consent extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject
{
    
    public static final String LOCAL_NAME = "Consent"; 
 
    public static final String PRINCIPAL_CONSENT_OBTAINED_URI = "urn:liberty:consent:obtained";
    
    // Attributes
    /**
     * A URI indicating that the Principal�s consent was obtained.
     * <p>
     * Optionally, the URI MAY identify a particular Consent Agreement Statement defining the specific nature of the consent obtained.
     * <p>
     * This specification defines one well-known URI Liberty implementors and deployers MAY use to indicate positive
     * Principal consent was obtained with respect to whatever ID-* interaction is underway or being initiated. This URI
     * is known as the "Principal Consent Obtained" URI (PCO). The value of this URI is:
     * <i>urn:liberty:consent:obtained</i>
     * <p>
     * This URI does not correspond to any particular Consent Agreement Statement. Rather, it simply states that consent
     * was obtained. The full meaning and implication of this will need to be derived from the execution context.
     */
    private String uri;         // required
    /**
     * For denoting the time at which the sender obtained Principal consent with the POC.
     */
    private DateTime timestamp;   
    private AttributeMap unknownAttributes;
    
    // Attribute Names
    public static final String ATT_URI = "uri";
    public static final String ATT_TIMESTAMP = "timestamp";
    
    public Consent()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }
    
    public Consent(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }


    public DateTime getTimestamp()
    {
        return timestamp;
    }


    public void setTimestamp(DateTime timestamp)
    {
        this.timestamp = prepareForAssignment(this.timestamp, timestamp);
    }


    public String getUri()
    {
        return uri;
    }


    public void setUri(String uri)
    {
        this.uri = prepareForAssignment(this.uri, uri);
    }


    public AttributeMap getUnknownAttributes()
    {
        if(null==unknownAttributes) unknownAttributes = new AttributeMap(this);
        return unknownAttributes;
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }
    

    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Consent obj = (Consent) xmlObject;

            if(attribute.getLocalName().equals(Consent.ATT_URI)) 
            {
                obj.setUri(attribute.getValue());
            } 
            else if (attribute.getLocalName().equals(Consent.ATT_TIMESTAMP)) 
            {
                obj.setTimestamp(  OpenLibertyHelpers.dateTimeForString( attribute.getValue() ));
            } 
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Consent obj = (Consent) xmlObject;             

            // uri is required, and therefore will always be here, or should throw an exception
            try
            {
                domElement.setAttributeNS(null, Consent.ATT_URI, obj.getUri());
            }
            catch(NullPointerException npe)
            {
                throw new MarshallingException("WSC Client Library: <sb:Consent> SOAP Header requires uri attribute. Failed on an attempt to marshall a Consent missing this required attribute.");
            }
            
            if(null!=obj.getTimestamp())
            {
                domElement.setAttributeNS(null, Consent.ATT_TIMESTAMP, OpenLibertyHelpers.stringForDateTime( obj.getTimestamp() ));
            }
            
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }

    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Consent>
    {
        @Override
        public Consent buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Consent(namespaceURI, localName, namespacePrefix);
        }        
    }

}
