package org.openliberty.xmltooling.soapbinding;



import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.EndpointReferenceMarshaller;
import org.openliberty.xmltooling.wsa.EndpointReferenceUnmarshaller;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * It may be necessary for an entity receiving an ID-* message to indicate that messages from the sender should be
 * directed to a different endpoint, or that they wish a different credential to be used than was originally specified
 * by the entity for access to the requested resource. The &lt;EndpointUpdate&gt; response header allows a message
 * receiver to indicate that a new endpoint or new credentials should be employed by the sender of the message on any
 * subsequent messages. This header block may be used in conjunction with the &lt;sb:InappropriateCredentials&gt;
 * and &lt;sb:EndpointUpdated&gt; faults, to indicate that the current message processing failed for those reasons, and
 * should be submitted with the changes noted in any accompanying &lt;EndpointUpdate&gt; header block.
 * <p>
 * <b>Note:</b> The use of this header block allows the sender of the message to convey updates to security tokens, essentially
 * providing a token renewal mechanism. This is not discussed further in this specification.
 * </p>
 * <p>
 * <pre>
 *     &lt;xs:complexType name="EndpointUpdateType"&gt;
 *         &lt;xs:complexContent&gt;
 *             &lt;xs:extension base="wsa:EndpointReferenceType"&gt;
 *                 &lt;xs:attribute name="updateType" type="xs:anyURI" use="optional"/&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:complexContent&gt;
 *     &lt;/xs:complexType&gt;
 *    
 *     &lt;xs:element name="EndpointUpdate" type="EndpointUpdateType"/&gt;
 * </pre>
 * </p>
 * 
 * @author asa
 *
 */
public class EndpointUpdate extends EndpointReference
{
    public static final String LOCAL_NAME = "EndpointUpdate";
    
    // Attributes
    private UpdateType updateType;    // xs:anyURI optional
    
    // Attribute Name
    public static final String ATT_UPDATE_TYPE = "updateType";
    
    /**
     * If updateType has the value urn:liberty:sb:2006-08:EndpointUpdate:Partial, the <wsa:EndpointUpdate>
     * MAY omit any direct children of <wsa:RefenceParameters> or <wsa:Metadata> that have not changed from
     * the original endpoint reference used to send the current request. Similarly, any extension elements that have not
     * changed MAY be omitted. If the address has not changed, then the URI
     * urn:liberty:sb:2006-08:EndpointUpdate:NoChange
     */
    public static final String NO_ADDRESS_CHANGE = "urn:liberty:sb:2006-08:EndpointUpdate:NoChange";
    
    protected EndpointUpdate()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }
        
    protected EndpointUpdate(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
   
    /**
     * This method indicates to the caller that there is no address change in the EndpointUpdate
     * 
     * @return
     */
    public boolean isNoAddressChange()
    {
        if(getUpdateType()==UpdateType.PARTIAL)
        {
            Address address = this.getAddress();
            if(NO_ADDRESS_CHANGE.equals(address.getValue())) return true;            
        }
        return false;
    }
    
    public UpdateType getUpdateType()
    {
        return updateType;
    }

    public void setUpdateType(UpdateType updateType)
    {
        this.updateType = prepareForAssignment(this.updateType, updateType);
    }
    
    
    
    public enum UpdateType
    {
        COMPLETE("urn:liberty:sb:2006-08:EndpointUpdate:Complete"),
        PARTIAL("urn:liberty:sb:2006-08:EndpointUpdate:Partial");  
        
        private String uri;      

        private UpdateType(String uri)
        {
            this.uri = uri;
        }
        
        public static UpdateType getUpdateTypeForUri(String uri)
        {
            if(null!=uri)
            {
                for(UpdateType updateType : UpdateType.values())
                {
                    if(uri.equals(updateType.uri)) return updateType;
                }
            }
            return null;
        }

        public String getUri()
        {
            return uri;
        }
        
    }
    
    
    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends EndpointReferenceUnmarshaller
    {
        
        /** {@inheritDoc} */
        @Override
		protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            EndpointUpdate obj = (EndpointUpdate) xmlObject;
            if (attribute.getLocalName().equals(EndpointUpdate.ATT_UPDATE_TYPE)) 
            {
                obj.setUpdateType(UpdateType.getUpdateTypeForUri(attribute.getValue()));
            } 
            else super.processAttribute(xmlObject, attribute);
        }
    }

    
    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends EndpointReferenceMarshaller 
    {
        
        /** {@inheritDoc} */
        @Override
		protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            EndpointUpdate obj = (EndpointUpdate) xmlObject;
            
            if(null!=obj.getUpdateType())
            {
                domElement.setAttributeNS(null, EndpointUpdate.ATT_UPDATE_TYPE, obj.getUpdateType().getUri());
            }
            
            super.marshallAttributes(xmlObject, domElement);
            
        }

    }
    
    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<EndpointUpdate>
    {
        @Override
        public EndpointUpdate buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new EndpointUpdate(namespaceURI, localName, namespacePrefix);
        }        
    }



}
