package org.openliberty.xmltooling.soapbinding;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * When included in a message, this header provides a means for a sender to communicate the version
 * of the ID-WSF framework used to construct the message.  This element is also used inside of  
 * EPR Metadata
 * 
 * @author asa
 *
 */
public class Framework extends AbstractSignableXMLObject implements ElementExtensibleXMLObject, AttributeExtensibleXMLObject
{
	
    public static final String VERSION_2_0 = "2.0";
    
    /** Local name of the SASL type. */
    public static final String DEFAULT_ELEMENT_LOCAL_NAME = "Framework"; 
        
    /** Default element name. */
    public static final QName DEFAULT_ELEMENT_NAME = new QName(Konstantz.SBF_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.SBF_PREFIX);
    
	public static String ATT_VERSION = "version";

	private String value;
	
	private String version;
	
	private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;
	
	/**
	 * Support for AttributeExtensibleXMLObject interface
	 */
	private AttributeMap otherAttributes;
	
	
	public Framework()
	{
	    super(Konstantz.SBF_NS, Framework.DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.SBF_PREFIX);
	    unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
	}
	
	protected Framework(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
	}
	
    public void setVersion(String version) 
    {
    	this.version = prepareForAssignment(this.version, version);
    }
    
    public String getVersion() 
    { 
    	return version; 
    }
    
	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }
    
	
	public List<XMLObject> getUnknownXMLObjects() 
    {
		return unknownXMLObjects;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }
    
	public List<XMLObject> getOrderedChildren() 
    {
		return null;
	}

	public AttributeMap getUnknownAttributes() 
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
		return otherAttributes;
	}

	/**
	 * Intenal Unmarshalling class
	 * 
	 * @author asa
	 *
	 */
	public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
	{
	    
	    @Override
	    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	    {
	        Framework framework = (Framework) xmlObject;

	        if (attribute.getLocalName().equals(Framework.ATT_VERSION)) 
	        {
	            framework.setVersion(attribute.getValue());
	        } 
	        else 
	        {
	            QName attribQName = QNameSupport.getNodeQName(attribute);
	            if (attribute.isId()) {
	                framework.getUnknownAttributes().registerID(attribQName);
	            }
	            framework.getUnknownAttributes().put(attribQName, attribute.getValue());
	        }        
	    }

	    
	    @Override
	    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	    {   
	        Framework obj = (Framework)parentXMLObject;
	        obj.getUnknownXMLObjects().add(childXMLObject);
	    }

	    
	    @Override
	    protected void processElementContent(XMLObject xmlObject, String elementContent) 
	    {
	        // NO CONTENT
	    }


	}
	
	
	/**
	 * Internal Marshaller Class
	 * @author asa
	 *
	 */
	public static class Marshaller extends AbstractXMLObjectMarshaller
	{

	    @Override
	    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
	    {
	        Framework framework = (Framework)xmlObject;

	        if(framework.getVersion() != null) 
	        {
	            domElement.setAttributeNS(null, Framework.ATT_VERSION, framework.getVersion());
	        }   
	        
	        Attr attr;
	        for(Entry<QName, String> entry: framework.getUnknownAttributes().entrySet()){
	            attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
	            attr.setValue(entry.getValue());
	            domElement.setAttributeNodeNS(attr);
	            if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || framework.getUnknownAttributes().isIDAttribute(entry.getKey())) {
	                attr.getOwnerElement().setIdAttributeNode(attr, true);
	            }
	        }

	    }

	    @Override
	    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
	    {
	        Framework framework = (Framework)xmlObject;
	        ElementSupport.appendTextContent(domElement, framework.getValue());
	    }




	}
	
	/**
	 * Internal Builder Class
	 * @author asa
	 *
	 */
	public static class Builder extends AbstractXMLObjectBuilder<Framework> 
	{
	    @Override
		public Framework buildObject(String namespaceURI, String localName, String namespacePrefix)
	    {
	        return new Framework(namespaceURI, localName, namespacePrefix);
	    }
	}


}
