package org.openliberty.xmltooling.soapbinding;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;
import org.opensaml.core.xml.util.AttributeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;



/**
 * This header block may be employed by a sender to signal to a receiver that the latter should add a specific additional 
 * facet to the overall processing context in which any action(s) are invoked as a result of processing any ID-* message 
 * also conveyed in the overall SOAP-bound ID-* message. The full semantics of this header block are described below in 
 * Section 6.1.2: &lt;ProcessingContext&gt; Header Block Semantics and Processing Rules .
 * <p>
 * Processing context facets are denoted by URIs. URIs are assigned to denote specific processing context facets. This specification 
 * defines several such URIs below in Section 6.1.2.2.
 * </p>
 * <p>
 * <pre>
 * &lt;xs:complexType name="ProcessingContextType"&gt;
 *     &lt;xs:simpleContent&gt;
 *       &lt;xs:extension base="xs:anyURI"&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:simpleContent&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 * </p>
 * @author asa
 *
 */
public class ProcessingContext extends XSStringImpl implements AttributeExtensibleXMLObject
{

    public static String LOCAL_NAME = "ProcessingContext";

    // Attributes 
    private AttributeMap otherAttributes;   

    public ProcessingContext()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
        otherAttributes = new AttributeMap(this);
    }

    protected ProcessingContext(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        otherAttributes = new AttributeMap(this);
    }

    public AttributeMap getUnknownAttributes()
    {
        return otherAttributes;
    }

    
    /**
     * New processing context facet identifiers MAY be defined in other specifications, for example in ID-SIS data 
     * service specifications. An ID-SIS data service may define as many levels of request context identifiers as necessary 
     * to address the application�s needs.
     * 
     * @author asa
     *
     */
    public enum Defined
    {
        /**
         * Conduct the processing of the ID-* message as if the Principal is offline.
         */
        PRINCIPAL_OFFLINE("urn:liberty:sb:2003-08:ProcessingContext:PrincipalOffline"),
        /**
         * Conduct the processing of the ID-* message as if the Principal is online.
         */
        PRINCIPAL_ONLINE("urn:liberty:sb:2003-08:ProcessingContext:PrincipalOnline"),
        /**
         * Simulate the processing of the ID-* message.
         */
        SIMULATE("urn:liberty:sb:2003-08:ProcessingContext:Simulate")
        ;
        
        private String uri;      

        private Defined(String uri)
        {
            this.uri = uri;
        }
        
        public static Defined getDefinedForUri(String uri)
        {
            if(null!=uri)
            {
                for(Defined obj : Defined.values())
                {
                    if(uri.equals(obj.uri)) return obj;
                }
            }
            return null;
        }

        public String getUri()
        {
            return uri;
        }
        
        
    }
    
    
    
    /**
     * Marshall attributes into the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSStringMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            ProcessingContext obj = (ProcessingContext)xmlObject;

            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

    }


    /**
     * Internal class that handles unmarshalling from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSStringUnmarshaller
    {       

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            ProcessingContext obj = (ProcessingContext) xmlObject;

            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

    }


    /** 
     * Internal Builder 
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ProcessingContext>
    {
        @Override
        public ProcessingContext buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ProcessingContext(namespaceURI, localName, namespacePrefix);
        }        
    }


}
