/**
 * Spec location: liberty-idwsf-soap-binding-2.0-errata-v1.0.pdf pg 53
 * 
 * <xs: element name="RedirectRequest" type="RedirectRequestType"/>
 * 	<xs: complexType name="RedirectRequestType">
 * 		<xs: attribute name="redirectURL" type="xs: anyURI" use="required"/>
 * </xs: complexType>
 * 
 * <S: Envelope xmlns: S="http: //schemas.xmlsoap.org/soap/envelope/"> 
 * 	<S: Header>
 * 		<wsa: MessageID xmlns: wsa="http: //www.w3.org/2005/ 02/addressing">...</wsa: MessageID>
 * 		<wsa: RelatesTo>...</wsa: RelatesTo>
 * 	</S: Header>
 * 	<S: Body>
 * 		<S: Fault>
 * 			<faultcode>SOAP-ENV: Server</faultcode>
 * 			<faultstring>Server Error</faultstring>
 * 			<detail>
 * 				<RedirectRequest redirectURL="https: //someWSP/getCo nsent?transID=de67hj89jk65nk34 ">
 * 					Redirecting to AP to obtain consent
 * 				</RedirectRequest>
 * 			</detail>
 * 		</S: Fault>
 * 	</S: Body>
 * </S: Envelope>
 * 
 */
package org.openliberty.xmltooling.soapbinding;

import java.util.List;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * <pre>
 *   &lt;xs:element name="RedirectRequest" type="RedirectRequestType"/&gt;
 * 
 *    &lt;xs:complexType name="RedirectRequestType"&gt;
 *       &lt;xs:attribute name="redirectURL" type="xs:anyURI" use="required"/&gt;
 *    &lt;/xs:complexType&gt;
 * </pre>
 * @author tguion
 * @author asa
 */
public class RedirectRequest extends AbstractSignableXMLObject 
{

    public static final String DEFAULT_ELEMENT_LOCAL_NAME = "RedirectRequest";

    public static final QName LOCAL_Q_NAME = new QName(Konstantz.SB_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.SB_PREFIX);

    public static final String REDIRECT_URL_ATTR_NAME = "redirectURL";

    /**
     * Required attribute: The URL to which the WSC should redirect the user
     * agent.
     */
    private String redirectURL;

    /**
     * Optional text content can be used to indicate the reason for the need for
     * redirection of the requesting principal
     */
    private String reason;

    /**
     * Constructor
     *
     */
    public RedirectRequest() 
    {
        super(Konstantz.SB_NS, RedirectRequest.DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.SB_PREFIX);
    }

    /**
     * Constructor
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
    protected RedirectRequest(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getRedirectURL() 
    { 
        return redirectURL; 
    }

    public void setRedirectURL(String value) 
    {
        this.redirectURL = prepareForAssignment(this.redirectURL, value);
    }

    /**
     * @return the reason
     */
    public String getReason() 
    {
        return reason;
    }

    /**
     * @param reason the reason to set
     */
    public void setReason(String reason) 
    {
        this.reason = reason;
    }

    /* (non-Javadoc)
     * @see org.opensaml.xml.XMLObject#getOrderedChildren()
     */
    public List<XMLObject> getOrderedChildren() 
    {
        // no children
        return null;
    }


    /**
     * Static Internal Unmarshaller
     * 
     * @author asa
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processAttribute(org.opensaml.xml.XMLObject, org.w3c.dom.Attr)
         */
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            RedirectRequest obj = (RedirectRequest) xmlObject;

            if (RedirectRequest.REDIRECT_URL_ATTR_NAME.equals(attribute.getLocalName())) 
            {
                obj.setRedirectURL(attribute.getValue());
            }
        }

        
        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processChildElement(org.opensaml.xml.XMLObject, org.opensaml.xml.XMLObject)
         */
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no child elements
        }

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processElementContent(org.opensaml.xml.XMLObject, java.lang.String)
         */
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            RedirectRequest obj = (RedirectRequest) xmlObject;
            obj.setReason(elementContent);
        }

    }



    /**
     * Static Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallAttributes(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
         */
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            RedirectRequest obj = (RedirectRequest) xmlObject;

            if (obj.getRedirectURL() != null) 
            {
                domElement.setAttributeNS(null, RedirectRequest.REDIRECT_URL_ATTR_NAME, obj.getRedirectURL());
            }
        }

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallElementContent(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
         */
        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            RedirectRequest obj = (RedirectRequest) xmlObject;
            ElementSupport.appendTextContent(domElement, obj.getReason());
        }

    }


    /**
     * Internal Builder
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<RedirectRequest> 
    {

        /* (non-Javadoc)
         * @see org.opensaml.xml.AbstractXMLObjectBuilder#buildObject(java.lang.String, java.lang.String, java.lang.String)
         */
        @Override
        public RedirectRequest buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new RedirectRequest(namespaceURI, localName, namespacePrefix);
        }

    }



}
