package org.openliberty.xmltooling.soapbinding;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;

/**
 * 
 * @author asa
 *
 */
public class SecurityMechID extends XSStringImpl
{
    
    public static final String LOCAL_NAME = "SecurityMechID";

    protected SecurityMechID()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }

    protected SecurityMechID(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * Wrapper for the SecurityMechID element content that returns an 
     * enumerated SecurityMechanism
     * 
     * @return
     */
    public Konstantz.WSFSecurityMechanism getSecurityMechanism()
    {
        return Konstantz.WSFSecurityMechanism.findSecurityMechanismForURI(getValue());
    }

    /**
     * Wrapper for setting the SecurityMechID element content that takes
     * an enumerated SecurityMechanism as its argument
     * 
     * @param securityMechanism
     */
    public void setSecurityMechanism(Konstantz.WSFSecurityMechanism securityMechanism)
    {
        if(null!=securityMechanism) super.setValue(securityMechanism.getUri());
        else super.setValue(null);
    }
        
    public static class Marshaller extends XSStringMarshaller
    {
    }
    
    public static class Unmarshaller extends XSStringUnmarshaller
    {        
    }
    
    // internal builder
    public static class Builder extends AbstractXMLObjectBuilder<SecurityMechID>
    {
        @Override
        public SecurityMechID buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new SecurityMechID(namespaceURI, localName, namespacePrefix);
        }        
    }
    
        
}