package org.openliberty.xmltooling.soapbinding;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * When included in a message, this header provides a means for a sender to claim that it is a provider identified by a 
 * given providerID value. The sender may also claim that it is a member of a given affiliation. Such claims are generally 
 * verifiable by receivers by looking up these values in the sender's metadata [LibertyMetadata].
 * <pre>
 *     &lt;xs:complexType name="SenderType"&gt;
 *         &lt;xs:attribute name="providerID" type="xs:anyURI" use="required"/&gt;
 *         &lt;xs:attribute name="affiliationID" type="xs:anyURI" use="optional"/&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *      &lt;/xs:complexType&gt;
 * 
 *      &lt;xs:element name="Sender" type="SenderType"/&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class Sender extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject
{
    public static final String LOCAL_NAME = "Sender";

    // Attributes 
    private String providerID;      // xs:anyURI required
    private String affiliationID;   // xs:anyURI optional
    private AttributeMap unknownAttributes;

    // Attribute Names
    public static final String ATT_PROVIDER_ID = "providerID";
    public static final String ATT_AFFILIATION_ID = "affiliationID";

    public Sender()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }
    
    protected Sender(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getAffiliationID()
    {
        return affiliationID;
    }

    public void setAffiliationID(String affiliationID)
    {
        this.affiliationID = prepareForAssignment(this.affiliationID, affiliationID);
    }

    public String getProviderID()
    {
        return providerID;
    }

    public void setProviderID(String providerID)
    {
        this.providerID = prepareForAssignment(this.providerID, providerID);
    }

    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }

    public AttributeMap getUnknownAttributes()
    {
        if(null==unknownAttributes) unknownAttributes = new AttributeMap(this);
        return unknownAttributes;
    }


    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Sender obj = (Sender) xmlObject;

            if (attribute.getLocalName().equals(Sender.ATT_PROVIDER_ID)) 
            {
                obj.setProviderID(attribute.getValue());
            } 
            else if (attribute.getLocalName().equals(Sender.ATT_AFFILIATION_ID)) 
            {
                obj.setAffiliationID(attribute.getValue());
            } 
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Sender obj = (Sender) xmlObject;             

            // Provider ID is required, and therefore will always be here, or should throw an exception
            try
            {
                domElement.setAttributeNS(null, Sender.ATT_PROVIDER_ID, obj.getProviderID());
            }
            catch(NullPointerException npe)
            {
                throw new MarshallingException("WSC Client Library: <sb:Sender> SOAP Header requires providerId attribute. Failed on an attempt to marshall a Sender missing this required attribute.");
            }

            if(null!=obj.getAffiliationID())
            {
                domElement.setAttributeNS(null, Sender.ATT_AFFILIATION_ID, obj.getAffiliationID());
            }

            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }



    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Sender>
    {
        @Override
        public Sender buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Sender(namespaceURI, localName, namespacePrefix);
        }        
    }



}
