package org.openliberty.xmltooling.soapbinding;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.common.AbstractExtensibleSOAPObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * When included in a message, this header provides a means for the sender to include an identity token (see [LibertySecMech]) 
 * that specifies an identity at the service that is the target of the message. For example, to obtain profile attributes for a 
 * principal, a query message might be sent to a profile service associated with the principal, including an identity token in 
 * the target identity header that specifies the principal's identity at the profile service.
 * <p>
 * AbstractExtensibleSOAPObject supports xs:any snf xs:anyAttribute, which is all that the TargetIdentity Header needs. 
 * </p>
 * <p>
 * <pre>
 *     &lt;xs:complexType name="TargetIdentityType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:any namespace="##any" processContents="lax" minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 *    
 *     &lt;xs:element name="TargetIdentity" type="TargetIdentityType"/&gt;
 * </pre>
 * </p>
 * @author asa
 *
 */
public class TargetIdentity extends AbstractExtensibleSOAPObject
{    
    public static final String LOCAL_NAME = "TargetIdentity";

    protected TargetIdentity()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }

    protected TargetIdentity(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            TargetIdentity obj = (TargetIdentity) xmlObject;
            
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            TargetIdentity obj = (TargetIdentity) parentXMLObject;
            obj.getUnknownXMLObjects().add(childXMLObject);
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            TargetIdentity obj = (TargetIdentity) xmlObject;             
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }



    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<TargetIdentity>
    {
        @Override
        public TargetIdentity buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new TargetIdentity(namespaceURI, localName, namespacePrefix);
        }        
    }



}
