package org.openliberty.xmltooling.soapbinding;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * A requesting entity may wish to indicate that they would like a request to be processed within some specified amount
 * of time. Such an entity would indicate their wish via the &lt;Timeout&gt; header block.
 * <p>
 * <pre>
 *     &lt;xs:complexType name="TimeoutType"&gt;
 *         &lt;xs:attribute name="maxProcessingTime" type="xs:integer" use="required"/&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 *    
 *     &lt;xs:element name="Timeout" type="TimeoutType"/&gt;
 * </pre>
 * </p>
 * 
 * @author asa
 *
 */
public class Timeout extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject
{

    public static final String LOCAL_NAME = "Timeout";
    
    // Attributes
    private AttributeMap unknownAttributes;
    /**
     * An integer specifying (in seconds) the maximum amount of time the sender 
     * wishes the receiver to spend in processing their request
     * 
     */
    private Integer maxProcessingTime;          // xs:integer required
    
    // Attribute Names
    public static final String ATT_MAX_PROCESSING_TIME = "maxProcessingTime";
    
    public Timeout()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }
    
    protected Timeout(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Integer getMaxProcessingTime()
    {
        return maxProcessingTime;
    }

    public void setMaxProcessingTime(Integer maxProcessingTime)
    {
        this.maxProcessingTime = prepareForAssignment(this.maxProcessingTime, maxProcessingTime);
    }

    public AttributeMap getUnknownAttributes()
    {
        if(null==unknownAttributes) unknownAttributes = new AttributeMap(this);
        return unknownAttributes;
    }

    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }
    


    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Timeout obj = (Timeout) xmlObject;

            if (attribute.getLocalName().equals(Timeout.ATT_MAX_PROCESSING_TIME)) 
            {
                obj.setMaxProcessingTime(  OpenLibertyHelpers.integerFromString( attribute.getValue() ));
            } 
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Timeout obj = (Timeout) xmlObject;             

            // maxProcessingTime is required, and therefore will always be here, or should throw an exception
            try
            {
                domElement.setAttributeNS(null, Timeout.ATT_MAX_PROCESSING_TIME, obj.getMaxProcessingTime().toString());
            }
            catch(NullPointerException npe)
            {
                throw new MarshallingException("WSC Client Library: <sb:Timeout> SOAP Header requires maxProcessingTime attribute. Failed on an attempt to marshall a Timeout missing this required attribute.");
            }

            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }

    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Timeout>
    {
        @Override
        public Timeout buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Timeout(namespaceURI, localName, namespacePrefix);
        }        
    }

    

}
