package org.openliberty.xmltooling.soapbinding;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.common.AbstractExtensibleSOAPObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * Participants in the ID-WSF framework may need to indicate the privacy policy associated with a message. To facilitate
 * this, senders, acting as either a client or a server, may add one or more &lt;UsageDirective&gt; header blocks to the
 * SOAP Header of the message being sent. A &lt;UsageDirective&gt; appearing in a SOAP-based ID-* request message
 * expresses intended usage. A &lt;UsageDirective&gt; appearing in a response expresses how the receiver of the response
 * is to use the response data. A &lt;UsageDirective&gt; in a response message containing no ID-WSF response message
 * data, a fault response for example, may be used to express policies acceptable to the responder.
 * <pre>
 *   &lt;xs:complexType name="UsageDirectiveType"&gt;
 *     &lt;xs:sequence&gt;
 *       &lt;xs:any namespace="##other" processContents="lax" 
 *         maxOccurs="unbounded"/&gt;
 *     &lt;/xs:sequence&gt;
 *     &lt;xs:attribute name="ref" type="xs:IDREF" use="required"/&gt;
 *     &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *   &lt;/xs:complexType&gt;
 * 
 *   &lt;xs:element name="UsageDirective" type="UsageDirectiveType"/&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class UsageDirective extends AbstractExtensibleSOAPObject
{

    public static final String LOCAL_NAME = "UsageDirective";

    // Attributes
    /**
     * An attribute referring to an element of the SOAP-based ID-* message to which the usage directive
     * applies.
     */
    private String ref; // required, XS:IDREF

    // Attribute Names
    public static final String ATT_REF = "ref";

    public UsageDirective()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }

    protected UsageDirective(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getRef()
    {
        return ref;
    }

    public void setRef(String ref)
    {
        this.ref = prepareForAssignment(this.ref, ref);
    }

    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            UsageDirective obj = (UsageDirective) xmlObject;

            if (attribute.getLocalName().equals(UsageDirective.ATT_REF)) 
            {
                obj.setRef(attribute.getValue());
            } 
            else
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            UsageDirective obj = (UsageDirective) parentXMLObject;
            obj.getUnknownXMLObjects().add(childXMLObject);
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            UsageDirective obj = (UsageDirective) xmlObject;        

            // ref is required, and therefore will always be here, or should throw an exception
            try
            {
                domElement.setAttributeNS(null, UsageDirective.ATT_REF, obj.getRef());
            }
            catch(NullPointerException npe)
            {
                throw new MarshallingException("WSC Client Library: <sb:UsageDirective> SOAP Header requires ref attribute. Failed on an attempt to marshall a UsageDirective missing this required attribute.");
            }


            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }



    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<UsageDirective>
    {
        @Override
        public UsageDirective buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new UsageDirective(namespaceURI, localName, namespacePrefix);
        }        
    }



}
