package org.openliberty.xmltooling.subs;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.utility_2_0.TestResult;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *   &lt;xs:complexType name="NotificationType"&gt;
 *     &lt;xs:sequence&gt;
 *       &lt;xs:element ref="lu:TestResult" minOccurs="0" maxOccurs="unbounded"/&gt;
 *     &lt;/xs:sequence&gt;
 *     &lt;xs:attribute name="id" use="optional" type="xs:ID"/&gt;
 *     &lt;xs:attribute name="subscriptionID" use="required" type="lu:IDType"/&gt;
 *     &lt;xs:attribute name="expires" use="optional" type="xs:dateTime"/&gt;
 *     &lt;xs:attribute name="endReason" use="optional" type="xs:anyURI"/&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class NotificationType extends AbstractXMLObject
{

    // Attributes
    private String id;              // xs:ID
    private String subscriptionID;  // xs:ID
    private DateTime expires;       // xs:dateTime
    private String endReason;       // xs:anyURI

    // Attribute Names
    public static String ATT_ID = "id";
    public static String ATT_SUBSCRIPTION_ID = "subscriptionID";
    public static String ATT_EXPIRES = "expires";
    public static String ATT_END_REASON = "endReason";

    // Elements
    private XMLObjectChildrenList<TestResult> testResults;


    public NotificationType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = prepareForAssignment(this.id, id);
    }

    public String getSubscriptionID()
    {
        return subscriptionID;
    }

    public void setSubscriptionID(String subscriptionID)
    {
        this.subscriptionID = prepareForAssignment(this.subscriptionID, subscriptionID); 
    }

    public DateTime getExpires()
    {
        return expires;
    }

    public void setExpires(DateTime expires)
    {
        this.expires = prepareForAssignment(this.expires, expires);
    }

    public String getEndReason()
    {
        return endReason;
    }

    public void setEndReason(String endReason)
    {
        this.endReason = prepareForAssignment(this.endReason, endReason);
    }

    public XMLObjectChildrenList<TestResult> getTestResults()
    {
        if(null==testResults) testResults = new XMLObjectChildrenList<TestResult>(this);
        return testResults;        
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=testResults) children.addAll(testResults); 
        return Collections.unmodifiableList(children);
    }

    /**
     * Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            NotificationType obj = (NotificationType)xmlObject;
            if(null!=obj.getId())
            {
                domElement.setAttributeNS(null, NotificationType.ATT_ID, obj.getId());
            }
            if(null!=obj.getSubscriptionID())
            {
                domElement.setAttributeNS(null, NotificationType.ATT_SUBSCRIPTION_ID, obj.getSubscriptionID());
            }
            if(null!=obj.getExpires())
            {
                domElement.setAttributeNS(null, NotificationType.ATT_EXPIRES, OpenLibertyHelpers.stringForDateTime(obj.getExpires()));
            }
            if(null!=obj.getEndReason())
            {
                domElement.setAttributeNS(null, NotificationType.ATT_END_REASON, obj.getEndReason());
            }        
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }
    
    
    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            NotificationType obj = (NotificationType)xmlObject;

            if (attribute.getLocalName().equals(NotificationType.ATT_ID)) 
            {
                obj.setId(attribute.getValue());
                // attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            }
            else if (attribute.getLocalName().equals(NotificationType.ATT_SUBSCRIPTION_ID)) 
            {
                obj.setSubscriptionID(attribute.getValue());
            } 
            else if (attribute.getLocalName().equals(NotificationType.ATT_EXPIRES)) 
            {
                obj.setExpires(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } 
            else if (attribute.getLocalName().equals(NotificationType.ATT_END_REASON)) 
            {
                obj.setEndReason(attribute.getValue());
            } 
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            NotificationType obj = (NotificationType)parentXMLObject;

            if(childXMLObject instanceof TestResult)
            {
                obj.getTestResults().add((TestResult)childXMLObject);
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }

    }




}
